package nicolib.comment;

import nicolib.api.alert.StreamInfo;

/**
 * アラート通知を受け取るためのインターフェース
 * @author hal
 *
 */
public interface AlertReceiverHandler {
	
	/**
	 * コメントサーバーからアラート通知が送られてきた時に呼び出されます。
	 * @param chat
	 * @param originalText 
	 */
	public void receiveAlertChat(AlertChat chat, String originalText);
	
	/**
	 * 番組情報APIの取得時に呼び出されます。
	 * AlertReceiver.connectServerのwithStreamInfo引数をtrueにした時のみ発生します。
	 * @param info API取得失敗時にはnullになります
	 * @param chat 元になったAlertChat
	 */
	public void receiveStreamInfo(StreamInfo info, AlertChat chat);
}
