package nicolib.comment;

import nicolib.api.NicoApiException;
import nicolib.api.live.PlayerStatus;

public class ChatReceiver extends ClientBase {
	protected PlayerStatus playerStatus;
	protected ChatReceiverHandler receiveHandler;
	
	public void setHandler(ChatReceiverHandler handler){
		this.receiveHandler = handler;
	}
	
	/**
	 * コメント受信通知を受け取るハンドラを設定します
	 * @param liveHandler
	 */
	public PlayerStatus getPlayerStatus() {
		return playerStatus;
	}
	
	/**
	 * 放送IDを指定してコメントサーバーに接続します
	 * @param liveId 放送ID（URL形式でもよい）
	 * @param resFrom コメント取得開始位置
	 * @return 接続を開始できたか
	 * @throws NicoApiException
	 */
	public boolean connectServer(String liveId, int resFrom) 
		throws NicoApiException 
	{
		playerStatus = PlayerStatus.get(liveId);
		
		if(!playerStatus.hasError()){
			return connectServer(playerStatus, resFrom);
		}

		return false;
	}
	
	/**
	 * 事前に取得したPlayerStatusを使用してコメントサーバーに接続します
	 * @param status
	 * @param resFrom コメント取得開始位置
	 * @return 接続を開始できたか
	 */
	public boolean connectServer (PlayerStatus status, int resFrom)
	{
		playerStatus = status;
		return super.connectServer(status.getAddr(), status.getPort(), status.getThread(), resFrom);
	}
	
	/**
	 * 変換されたデータをハンドラに渡します
	 */
	protected void commentServ(Object obj, String text){
		
		if(receiveHandler != null) {
			if(obj instanceof Chat){
				receiveHandler.receiveChat((Chat)obj, text);
				return;
			}
		}
		
		super.commentServ(obj, text);
	}
}
