package nicolib.comment;

import java.util.Queue;


/**
 * 生放送コメントの送受信を行うクラス
 * （送信は未実装）
 * @author hal
 *
 */
public class ChatTransceiver extends ChatReceiver {

	protected ChatTransceiverHandler transceiverHandler;
	protected Queue<CommentTask> taskQueue;
	
	/**
	 * コメント送受信通知を受け取るハンドラを設定します
	 * @param liveHandler
	 */
	public void setHandler(ChatTransceiverHandler handler){
		this.transceiverHandler = handler;
	}
	
	/**
	 * 生放送データ解析用オブジェクトを取得します
	 * @return
	 */
	protected StreamParser getParser() {
		if(super.parser == null){
			super.parser = new LiveStreamPaser();
		}
		return super.parser;
	}
		
	/**
	 * 変換されたデータをハンドラに渡します
	 */
	protected void commentServ(Object obj, String text){
		
		if(transceiverHandler != null) {
			if(obj instanceof Chat){
				transceiverHandler.receiveChat((Chat)obj, text);
				return;
			}else if(obj instanceof ChatResult){
				transceiverHandler.receiveChatResult((ChatResult)obj, text);
				return;
			}
		}
		
		super.commentServ(obj, text);
		
	}
	
	class CommentTask{
		String comment;
		String command;
		
		public CommentTask(String comment, String command){
			this.comment = comment;
			this.command = command;
		}
	}
}
