package nicolib.comment;

import org.xml.sax.Attributes;

/**
 * 生放送コメントサーバーから受け取った文字列をオブジェクトに変換するためのクラス
 * @author hal
 *
 */
class LiveStreamPaser extends StreamParser {
	private ChatResult chatResult;
	
	public synchronized Object parse(String text){
		chatResult = null;
		
		Object res = super.parse(text);
		
		if(res != null) return res;
		else return chatResult;
	} 
		
	public void startElement(String uri, String localName, String qName, Attributes attributes) {
		super.startElement(uri, localName, qName, attributes);
		
		if(qName.equals("chat_result")){
			chatResult = new ChatResult();
			parseChatResultAttributes(attributes, chatResult);
		}
	}
	
	private void parseChatResultAttributes(Attributes attributes, ChatResult result){
		//<chat_result no=\"523\" status=\"0\" thread=\"1019454199\"/>"
		
		String data = attributes.getValue("no");
		if(data != null) result.no = Integer.parseInt(data);
		
		data = attributes.getValue("status");
		if(data != null) result.status = Integer.parseInt(data);
		
		data = attributes.getValue("thread");
		if(data != null) result.thread = Integer.parseInt(data);
	}
}
