package nicolib.util;

import java.rmi.server.UID;
import java.security.GeneralSecurityException;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;


/**
 * 暗号化クラス
 * 参考　http://www.itmedia.co.jp/enterprise/articles/0407/01/news017.html
 * @author hal
 */
public class Crypt {
	
	/**
	 * ホスト上で一意になるKeyを使用してtextを暗号化します
	 * 
	 * @param text 暗号化するテキスト
	 * @return 結果
	 * @throws IllegalArgumentException 引数に不備があった場合に発生します
	 * @throws GeneralSecurityException 暗号化に失敗した際に発生します
	 */
	public static byte[] encrypt(String text) 
	throws IllegalArgumentException, 
		GeneralSecurityException
	{
		return encrypt(text, GenerateUniqueKey());
	}
	
	/**
	 * keyを使用してtextを暗号化します
	 * 
	 * @param text 暗号化するテキスト
	 * @param key 暗号化に使用する鍵
	 * @return 結果
	 * @throws IllegalArgumentException 引数に不備があった場合に発生します
	 * @throws GeneralSecurityException 暗号化に失敗した際に発生します
	 */
	public static byte[] encrypt(String text, String key) 
		throws IllegalArgumentException, 
			GeneralSecurityException
	{
		
		if(key == null){
			throw new IllegalArgumentException("key");
		}
		
		if(text == null){
			throw new IllegalArgumentException("text");
		}

		SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
		Cipher cipher = Cipher.getInstance("Blowfish");
		cipher.init(javax.crypto.Cipher.ENCRYPT_MODE, sksSpec);
		
		byte[] encrypted = cipher.doFinal(text.getBytes());
		return encrypted;
	}
	
	
	/**
	 * ホスト上で一意になるKeyを使用して暗号化されたテキストを復元します
	 * 
	 * @param encrypted 暗号化されたテキスト
	 * @return 結果
	 * @throws IllegalArgumentException 引数に不備があった場合に発生します
	 * @throws GeneralSecurityException 複合化に失敗した際に発生します
	 */
	public static String decrypt(byte[] encrypted)
		throws IllegalArgumentException, 
		GeneralSecurityException
	{
		return decrypt(encrypted, GenerateUniqueKey());	
	}
	
	/**
	 * keyを使用して暗号化されたテキストを復元します
	 * 
	 * @param encrypted 暗号化されたテキスト
	 * @param key 復号化に使用するキー
	 * @return 結果
	 * @throws IllegalArgumentException 引数に不備があった場合に発生します
	 * @throws GeneralSecurityException 復号化に失敗した際に発生します
	 */
	public static String decrypt(byte[] encrypted, String key)
		throws IllegalArgumentException, 
			GeneralSecurityException
	{
		if(encrypted == null || encrypted.length == 0){
			throw new IllegalArgumentException("encrypted");
		}
		
		if(key == null){
			throw new IllegalArgumentException("key");
		}
		
		SecretKeySpec sksSpec = new SecretKeySpec(key.getBytes(), "Blowfish");
		Cipher cipher = Cipher.getInstance("Blowfish");
		cipher.init(Cipher.DECRYPT_MODE, sksSpec);
		
		byte[] decrypted = cipher.doFinal(encrypted);
		return new String(decrypted);		
	}
	
	private static String GenerateUniqueKey(){
		UID uid = new UID();
		return uid.toString();
	}
	
}
