package namaComment;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpCookie;
import java.net.URL;

import javax.net.ssl.HttpsURLConnection;

/**
 * ニコニコサービスの基底クラス
 * @author もめんと
 *
 * TODO この生成された型コメントのテンプレートを変更するには次へジャンプ:
 * ウィンドウ - 設定 - Java - コード・スタイル - コード・テンプレート
 */
public class NicoSuper{
	protected static final String SESSION_KEYNAME = "user_session";
	private static final String NICO_LOGIN = "https://secure.nicovideo.jp/secure/login?site=niconico";
	protected String user_session = null;

	//mail&passで生成
	public NicoSuper(String mail, String pass) throws IOException{
		this.nicoLogIn(mail, pass);
	}
	//user_session直指定で生成
	public NicoSuper(String user_session){
		this.user_session = user_session;
	}

	//user_sessionを取得
	//投げる例外は失敗時。
	private void nicoLogIn(String mail, String pass) throws IOException{
		//ログインしてuser_sessionを取得する。
        URL api = new URL(NICO_LOGIN);
        HttpsURLConnection https = (HttpsURLConnection)api.openConnection();
        final String params = String.format("mail=%s&password=%s", mail, pass);

        https.setRequestMethod("POST");
        https.setDoOutput(true);
        https.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
        https.setRequestProperty("Content-Length", Integer.toString(params.length()));

        PrintStream out = new PrintStream(https.getOutputStream());
        out.print(params);
        BufferedReader in = new BufferedReader(new InputStreamReader(https.getInputStream()));

        // TODO 取れないときの処理が未実装

        String session = https.getHeaderField("Set-Cookie");
        String[] user_session = session.substring(0, session.indexOf(";")).split("=");

        this.user_session = user_session[1];
	}

	public String getUserSession(){
		return this.user_session;
	}
}
