<?php
/**
 * NicoAlert_demo.php
 * 
 * @author poochin
 * @package nicolib
 * @version $Id:$
 * @copyright Copyright (c) 2009-2010 poochin.
 */
require_once 'NicoLib/NicoLib.php';
require_once 'login_data.php';

$nico_alert = new NicoAlert;
$nico_alert->login($login_data['mail'], $login_data['password']);

/**
 * コメントサーバ仕様のクラスを取得
 */
$nico_alert_socket = $nico_alert->connectAlertServer();

/**
 * 接続に失敗した場合は null が返ってきている
 */
if ($nico_alert_socket == null) {
    exit;
}

while ($nico_alert_socket->aliveSocket())
{
    $new_chats = $nico_alert_socket->getLives();
    
    if (!empty($new_chats)) {
        foreach ($new_chats as $chat) {
            echo sprintf("live_id=%s, owner_id=%s, community_id=%s\n", $chat['lv_id'], $chat['owner_id'], $chat['community_id']);
        }
    }
    
    sleep(1);
}
