﻿//-------------------------------------------------------------------------
// 外部コメントウィンド
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: CommentForm.cs 578 2010-06-08 10:26:18Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.ComponentModel;
using System.Windows.Forms;

//-------------------------------------------------------------------------
// クラス実装
//-------------------------------------------------------------------------
namespace NicoLive
{
    public partial class CommentForm : Form
    {
        #region 変数
        private Form1 mOwner = null;
        #endregion

        #region 列挙列
        // コメントカラム
        private enum CommentColumn
        {
            COLUMN_NUMBER = 0,			// 番号
            COLUMN_ID,					// ＩＤ
            COLUMN_HANDLE,				// コテハン
            COLUMN_COMMENT,				// コメント
        }
        #endregion

        //-------------------------------------------------------------------------
        // 来場者数
        //-------------------------------------------------------------------------
        public string TotalCnt
        {
            set { mTotalCnt.Text = value; }
        }
        //-------------------------------------------------------------------------
        // アクティブ数
        //-------------------------------------------------------------------------
        public string ActiveCnt
        {
            set { mActiveCnt.Text = value; }
        }

        //-------------------------------------------------------------------------
        // トータル数
        //-------------------------------------------------------------------------
        public string UniqCnt
        {
            set { mUniqCnt.Text = value; }
        }

        //-------------------------------------------------------------------------
        // CPU
        //-------------------------------------------------------------------------
        public string CpuInfo
        {
            set { mCpuInfo.Text = value; }
        }
        //-------------------------------------------------------------------------
        // Battery
        //-------------------------------------------------------------------------
        public string Battery
        {
            set { mBattery.Text = value; }
        }
        //-------------------------------------------------------------------------
        // UpLink
        //-------------------------------------------------------------------------
        public string UpLink
        {
            set { mUpLink.Text = value; }
        }
        //-------------------------------------------------------------------------
        // コンストラクタ
        //-------------------------------------------------------------------------
        public CommentForm(Form1 iOwner)
        {
            mOwner = iOwner;

            InitializeComponent();

            this.mCommentList.Columns[0].Width = Properties.Settings.Default.column_width_ext_0;
            this.mCommentList.Columns[1].Width = Properties.Settings.Default.column_width_ext_1;
            this.mCommentList.Columns[2].Width = Properties.Settings.Default.column_width_ext_2;
            this.mCommentList.Columns[3].Width = Properties.Settings.Default.column_width_ext_3;

            this.mCommentList.BackgroundColor = Properties.Settings.Default.back_color;
            this.mCommentList.RowsDefaultCellStyle.ForeColor = Properties.Settings.Default.text_color;

            // フォントを設定しておく
            ResetCommentFont();
        }
        //-------------------------------------------------------------------------
        // コメント追加
        //-------------------------------------------------------------------------
        public void AddComment( Comment iCmt)
        {
            // フォントを設定しておく
            if (this.mCommentList.Font.Size != Properties.Settings.Default.font_size)
                ResetCommentFont();

            Utils.AddComment(ref mCommentList, iCmt);
        }
        //-------------------------------------------------------------------------
        // フォント設定
        //-------------------------------------------------------------------------
        private void ResetCommentFont()
        {
            Utils.SetCommentFont(ref mCommentList);
        }
        //-------------------------------------------------------------------------
        // コメントクリア
        //-------------------------------------------------------------------------
        public void Clear()
        {
            this.mCommentList.Rows.Clear();
        }
        //-------------------------------------------------------------------------
        // コメントクリア
        //-------------------------------------------------------------------------
        private void OnClosing(object sender, FormClosingEventArgs e)
        {
            if (e.CloseReason == CloseReason.UserClosing)
            {
                e.Cancel = true;
                Properties.Settings.Default.column_width_ext_0 = this.mCommentList.Columns[0].Width;
                Properties.Settings.Default.column_width_ext_1 = this.mCommentList.Columns[1].Width;
                Properties.Settings.Default.column_width_ext_2 = this.mCommentList.Columns[2].Width;
                Properties.Settings.Default.column_width_ext_3 = this.mCommentList.Columns[3].Width;
                Hide();
            }
        }
        //-------------------------------------------------------------------------
        // ニックネーム変更
        //-------------------------------------------------------------------------
        public void SetNickname(string iID, string iName)
        {
            Utils.SetNickname(ref mCommentList, iID, iName);
        }

        #region イベントハンドラ
        //-------------------------------------------------------------------------
        // コメントのコピー
        //-------------------------------------------------------------------------
        private void CopyComment_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string cmt = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Value.ToString();
                Clipboard.SetDataObject(cmt, true);
            }
        }
        //-------------------------------------------------------------------------
        // コメントリストのコンテクストメニュー表示開始時
        //-------------------------------------------------------------------------
        private void mCmtCxtMenu_Opening(object sender, CancelEventArgs e)
        {
            this.mCopyComment.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.mCopyID.Enabled = (this.mCommentList.SelectedRows.Count > 0);
            this.mRename.Enabled = (this.mCommentList.SelectedRows.Count > 0);

            int r;
            if (this.mCommentList.SelectedRows.Count > 0 &&
                int.TryParse(mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString(), out r))
            {
                this.mShowUserPage.Enabled = true;
            }
            else
            {
                this.mShowUserPage.Enabled = false;
            }
        }
        //-------------------------------------------------------------------------
        // IDのコピー
        //-------------------------------------------------------------------------
        private void CopyID_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string id = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                Clipboard.SetDataObject(id, true);
            }
        }

        //-------------------------------------------------------------------------
        // URLを開く
        //-------------------------------------------------------------------------
        private void OpenURL_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string msg = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_COMMENT].Value.ToString();

                if (msg.Length == 0) return;

                Utils.OpenURL(msg);
            }
        }

        //-------------------------------------------------------------------------
        // ユーザーページを開く
        //-------------------------------------------------------------------------
        private void ShowUserPage_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                string id = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                string uri = "http://www.nicovideo.jp/user/" + id;
                System.Diagnostics.Process.Start(uri);
            }
        }

        //-------------------------------------------------------------------------
        // コテハンリネーム
        //-------------------------------------------------------------------------
        private void Rename_Click(object sender, EventArgs e)
        {
            if (this.mCommentList.SelectedRows.Count > 0)
            {
                Rename rm = new Rename();
                rm.MyOwner = mOwner;
                rm.ID = this.mCommentList.SelectedRows[0].Cells[(int)CommentColumn.COLUMN_ID].Value.ToString();
                rm.Show();
            }
        }

        #endregion

        //-------------------------------------------------------------------------
        // ニックネーム変更
        //-------------------------------------------------------------------------
        private void UITimer_Tick(object sender, EventArgs e)
        {
            // 色設定
            if (mCommentList.RowsDefaultCellStyle.BackColor != Properties.Settings.Default.back_color)
            {
                mCommentList.RowsDefaultCellStyle.BackColor = Properties.Settings.Default.back_color;
                mCommentList.BackgroundColor = Properties.Settings.Default.back_color;
            }

            if (mCommentList.RowsDefaultCellStyle.ForeColor != Properties.Settings.Default.text_color)
            {
                mCommentList.RowsDefaultCellStyle.ForeColor = Properties.Settings.Default.text_color;
            }
        }

    }
}
//-------------------------------------------------------------------------
// 外部コメントウィンド
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: CommentForm.cs 578 2010-06-08 10:26:18Z kintoki $
//-------------------------------------------------------------------------
