﻿//-------------------------------------------------------------------------
// FMLEcmdクラス
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: FMLE.cs 770 2010-09-11 14:19:23Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Text;
using System.Diagnostics;
using System.Threading;
using System.IO;
using System.Xml;
using System.Runtime.InteropServices;

namespace NicoLive
{
    class FMLE
    {
        // FME開始フラグ
        private static bool mFMEStarted = false;


        public static bool FMEStarted
        {
            set { mFMEStarted = value; }
            get { return mFMEStarted; }
        }

        //-------------------------------------------------------------------------
        // 開始
        //-------------------------------------------------------------------------
        public static void Start(Dictionary<string, string> iParams)
        {
            if (hasFME() ) return;
            // FMLECmdのパス
            string APP_PATH = Properties.Settings.Default.fmle_path;
            // プロファイルのパス
            string profile_path = Path.GetTempPath() + "nicovideo_fme.xml";
            
            Thread th = new Thread(delegate()
            {
                // プロファイル作成
                if (!MakeProfile(profile_path, iParams))
                {
                    mFMEStarted = false;
                    return;
                }
                
                // FMLECmd起動
                string args = " /p \"" + profile_path + "\"";

                if (Properties.Settings.Default.fme_dos)
                {
                    Process.Start(APP_PATH, args);
                }
                else
                {
                    ProcessStartInfo psInfo = new ProcessStartInfo();
                    psInfo.FileName = APP_PATH;
                    psInfo.CreateNoWindow = true;
                    psInfo.UseShellExecute = false;
                    psInfo.Arguments = args;
                    Process.Start(psInfo);
                }
				using( Bouyomi bm = new Bouyomi() ) {
					bm.Talk("えふえむいー配信を開始しました");
				}
                mFMEStarted = true;
            });
            th.Start();
        }

        //-------------------------------------------------------------------------
        // FMEが動作中かチェック
        //-------------------------------------------------------------------------
		public static bool hasFME() 
		{
            Process[] ps = Process.GetProcessesByName("FMLECmd");

            return (ps.Length > 0);
		}

        //-------------------------------------------------------------------------
        // 停止
        //-------------------------------------------------------------------------
        public static void Stop()
        {
            Process[] ps = Process.GetProcessesByName("FMLECmd");

            foreach (System.Diagnostics.Process p in ps)
            {
                p.Kill();
            }
            mFMEStarted = false;
        }

        //-------------------------------------------------------------------------
        // プロファイル生成
        //-------------------------------------------------------------------------
		public static bool MakeProfile(string iPath,Dictionary<string, string> iParams)
		{
            // テンプレート読み込み
            XmlDocument doc = new XmlDocument();
            try
            {
                string path = System.Windows.Forms.Application.StartupPath + "\\nicovideo_fme.xml";

                doc.Load(path);

                string url = iParams["url"];
                string stream = iParams["stream"];

                if (Properties.Settings.Default.use_fme_device)
                {
                    LiveInfo info = LiveInfo.Instance;
                    doc.SelectSingleNode("//flashmedialiveencoder_profile/capture/video/device").InnerText = info.Camera;
                    doc.SelectSingleNode("//flashmedialiveencoder_profile/capture/audio/device").InnerText = info.Mic;
                }

                doc.SelectSingleNode("//flashmedialiveencoder_profile/output/rtmp/url").InnerText = url;
                doc.SelectSingleNode("//flashmedialiveencoder_profile/output/rtmp/stream").InnerText = stream;
				string video_dir =  System.Environment.GetFolderPath(Environment.SpecialFolder.Personal)+@"\My Video";
				if( !Directory.Exists( video_dir ) ){
                    System.IO.Directory.CreateDirectory(video_dir);
				}
                doc.SelectSingleNode("//flashmedialiveencoder_profile/log/directory").InnerText = video_dir;
                
                using (XmlTextWriter writer = new XmlTextWriter(iPath, Encoding.Unicode))
                {
                    writer.Formatting = Formatting.Indented;
                    doc.Save(writer);
                }
            }
            catch (Exception e)
            {
                Debug.WriteLine(e.Message);
                return false;
            }
            return true;
		}
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: FMLE.cs 770 2010-09-11 14:19:23Z kintoki $
//-------------------------------------------------------------------------
