﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: EventHandler.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Diagnostics;
using System.Drawing;
using Flash.External;

namespace NicoLive
{
    partial class Form1
    {

        //-------------------------------------------------------------------------
        // フォームロード
        //-------------------------------------------------------------------------
        private void Form1_Load(object sender, EventArgs e)
        {
            mBuyBtn.Enabled = false;
            mLastResTime = DateTime.Now;

            mNico = Nico.Instance;
            mBouyomi = new Bouyomi();

            mSpeakList = new List<string>();
            mGatherUserID = new List<string>();
            mCommentForm = new CommentForm(this);

            mUid = UserID.Instance;
            //mNG = NG.Instance;
            
            mLiveInfo = LiveInfo.Instance;
            mRes = Response.Instance;
  
            // Response読み込み
            mRes.LoadResponse();

            // IDロード
            UserID uid = UserID.Instance;
            uid.LoadUserID(true);
            uid.LoadUserID(false);
             
            // 最後に取得した放送ＩＤを設定
            this.mLiveID.Text = Properties.Settings.Default.last_lv;

            // バージョンチェック開始
            CheckVersion();

            // 来場者数更新用ワーカースタート
            this.mUpdateInfoWorker.RunWorkerAsync();

            // コメント処理ワーカースタート
            this.mCommentWorker.RunWorkerAsync();


            // ユーザー名収集ワーカー
            this.mGatherUserIDWorker.RunWorkerAsync();

            mWakutoriBtn.Text = mWakutoriBtn.Text + "(F1)";
            mCopyBtn.Text = mCopyBtn.Text + "(F2)";
            mImakokoBtn.Text = mImakokoBtn.Text + "(F3)";
            mCommentBtn.Text = mCommentBtn.Text + "(F4)";
            mAutoExtendBtn.Text = mAutoExtendBtn.Text + "(F5)";
            mContWaku.Text = mContWaku.Text + "(F6)";
            mVisitorBtn.Text = mVisitorBtn.Text + "(F7)";
            mBouyomiBtn.Text = mBouyomiBtn.Text + "(F8)";

            // ウィンドステート復帰
            //this.Width = Properties.Settings.Default.mw_size.Width;
            //this.Height = Properties.Settings.Default.mw_size.Height;
            this.Top = Properties.Settings.Default.mw_pos.Y;
            this.Left = Properties.Settings.Default.mw_pos.X;
           
            mProxy = new ExternalInterfaceProxy(mFlash);
            mProxy.ExternalInterfaceCall += new ExternalInterfaceCallEventHandler(onFromFlash);

            GetPlayer();

            mCommentForm.Show();
            
            // 棒読みちゃん起動
            Bouyomi.Launch();

            // 今ココ起動
            ImakokoNow.Launch();
        }

        //-------------------------------------------------------------------------
        // フォームクローズ
        //-------------------------------------------------------------------------
        private void Form1_FormClosing(object sender, FormClosingEventArgs e)
        {
            FMLE.Stop();

            if (mLogger != null)
            {
                try
                {
                    mLogger.Close();
                    mLogger = null;
                }
                catch (Exception ex)
                {
                    Debug.WriteLine(ex.Message);
                }
            }
            // ID保存
            mUid.SaveUserID(false);
            mUid.SaveUserID(true);

            mCommentForm.SaveProp();
           

            // ウィンドステート保存
            if (this.WindowState == FormWindowState.Normal)
            {
                Point pos = new Point(this.Top, this.Left);
                Properties.Settings.Default.mw_pos = pos;
            }
            
            // セーブ
            Properties.Settings.Default.Save();

            // 棒読みちゃん終了
            Bouyomi.Exit();

            // 今ココ終了
            ImakokoNow.Exit();

            mNico = null;
        }

        //-------------------------------------------------------------------------
        // 初回表示時
        //-------------------------------------------------------------------------
        private void Form1_Shown(object sender, EventArgs e)
        {
        }
    }
}
//-------------------------------------------------------------------------
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: EventHandler.cs 766 2010-09-11 08:00:14Z kintoki $
//-------------------------------------------------------------------------
