﻿//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
// $Id: Form1.cs 770 2010-09-11 14:19:23Z kintoki $
//-------------------------------------------------------------------------
using System;
using System.Collections.Generic;
using System.IO;
using System.Threading;
using System.Windows.Forms;
using Flash.External;
using System.Diagnostics;

//-------------------------------------------------------------------------
// クラス実装
//-------------------------------------------------------------------------
namespace NicoLive
{
    // フォームクラス
    public partial class Form1 : Form
    {
        #region 変数
        // ニコニコアクセスクラス
        private Nico mNico = null;

        // 棒読みちゃんアクセスクラス
        private Bouyomi mBouyomi = null;

        // コテハン用クラス
        private UserID mUid = null;

        // 放送情報管理クラス
        private LiveInfo mLiveInfo = null;

        // 読み上げコメントリスト
        private List<string> mSpeakList = null;
        static readonly object mSpeakLock = new object();

        // ＮＧワード
        //private NG mNG = null;

        // ユーザー名取得スレッド
        private List<string> mGatherUserID = null;
        private ReaderWriterLock mGatherLock = new ReaderWriterLock();

        // 来場者がこれ以上になったとき読み上げる
        private int mTargetVisitorCnt = 10;

        // 来場者数
        private int mVisitorCnt = 0;

        // ロガー
        private StreamWriter mLogger = null;

		// メッセージ設定
        private MessageSettings mMsg;

        // 外部コメントウィンド
        private CommentForm mCommentForm;

        // 返信クラス
        private Response mRes;

        // keepaliveコメントを送信するタイミング（5分おき）
        private readonly int KEEP_ALIVE_TIME = 5;

        // 最後にコメントを受信した時間
        private DateTime mLastChatTime;

        // 最後に自動返答した時間
        private DateTime mLastResTime;

        private UInt32 mNextGC;

        private Viewer mViewer = null;

        private string mCurrentLiveID = "";

        private STATUS_FLAGS mCurStatus = STATUS_FLAGS.NONE;

        private SaleList mFreeExtendItem;

        private ExternalInterfaceProxy mProxy;

        private bool mPlayerLoaded = false;

        private List<SaleList> mSaleList;

        private int mBuyItemIdx;
        
        private string mBuyItemName;

        #endregion

        #region フラグ
        enum STATUS_FLAGS
        {
            NONE           = 0,
            NEED_CONNECT   = 1,           // 接続コマンド送信要求
            TALK_LIMIT     = 1 << 2,      // 残り時間読み上げ要求
            TALK_LIMIT_END = 1 << 3,      // 残り時間読み上げ完了
            TW_START_POST  = 1 << 4,      // Twitterに開始メッセージポスト要求
            OWN_LIVE       = 1 << 5,      // 自分の配信かどうか
            SKIP_BOUYOMI   = 1 << 6,      // 棒読みちゃんに読ませない
            SKIP_LOGIN     = 1 << 7,      // ログインシーケンススキップ
            PUSH_START_AUTO= 1 << 8,      // 自動で配信開始ボタンが押されたかどうか
            PUSH_EXT_AUTO  = 1 << 9,      // 自動で延長ボタンを押したかどうか
            IS_EXTEND      = 1 << 10,     // 延長したかどうか
            DISCONNECT     = 1 << 11,     // 切断済みかどうか
            START_FME_AUTO = 1 << 12,     // FMEが自動起動したかどうか
            PREV_LOGIN     = 1 << 13,     // 前フレームでログイン状態だったかどうか
            NEED_FREE_EXTEND_0 = 1 << 14, // 無料延長要求
            NEED_FREE_EXTEND_1 = 1 << 15,   
            NEED_FREE_EXTEND_2 = 1 << 16,
            PUBLISH_START  = 1 << 17,
            EXTEND_ITEM_LOCK = 1 << 18,
            BUY_ITEM = 1 << 19,
            RECV_MSG = 1 << 20,
        }

        #endregion

        #region 列挙列
        // コメントカラム
        private enum CommentColumn : int
        {
            COLUMN_NUMBER = 0,			// 番号
            COLUMN_ID,					// ＩＤ
            COLUMN_HANDLE,				// コテハン
            COLUMN_COMMENT,				// コメント
        }
        #endregion

        //-------------------------------------------------------------------------
        // 放送ＩＤ
        //-------------------------------------------------------------------------
        public string LiveID
        {
            set { this.mLiveID.Text = value; }
            get { return this.mCurrentLiveID; }
        }

        //-------------------------------------------------------------------------
        // コンポーネント初期化
        //-------------------------------------------------------------------------
        public Form1()
        {
            InitializeComponent();

            Properties.Settings.Default.auto_wakutori = true;
            
            // メッセージロード
            mMsg = MessageSettings.Instance;
            mMsg.Load();

            mWakutoriBtn.Enabled = false;
            mConnectBtn.Enabled = false;
            mCopyBtn.Enabled = false;
        }

        //-------------------------------------------------------------------------
        // 接続
        //-------------------------------------------------------------------------
        public void Connect(bool iSkipLogin)
        {
            if (mLoginWorker.IsBusy)
                return;
            FlashAppendLog("接続します");

            mCurStatus = 0;
            mLastResTime = DateTime.Now;

            mNextGC = 0;
            mNico.Comment = "";
            mTargetVisitorCnt = 10;

            AddStatus(STATUS_FLAGS.SKIP_BOUYOMI);

            if (iSkipLogin)
                AddStatus(STATUS_FLAGS.SKIP_LOGIN);
            else
                DelStatus(STATUS_FLAGS.SKIP_LOGIN);

            mSpeakList.Clear();
            mLiveInfo.Clear();

            mCurrentLiveID = "";
            // 放送ＩＤをフォーマット
            mLiveID.Text = ParseLiveID();

            // 切断
            mNico.Close();

            if (mLogger != null)
            {
                mLogger.Close();
                mLogger = null;
            }

            // 放送IDが空
            if (this.mLiveID.Text.Length == 0)
            {
                MessageBox.Show("放送ＩＤが空です。","NicoLive");
                return;
            }


            // 外部コメントウィンド
            this.Invoke((Action)delegate()
            {
                this.mConnectBtn.Enabled = false;
                mCommentForm.Clear();
            }); 
            
            mLastChatTime = DateTime.Now;

            GC.Collect();

            // ログインワーカースタート
            mLoginWorker.RunWorkerAsync();
        }

        //-------------------------------------------------------------------------
        // 放送ＩＤ取得
        //-------------------------------------------------------------------------
        public string ParseLiveID()
        {
            if (this.mLiveID == null || this.mLiveID.Text == null) return "";

            string tmp = Utils.ParseLiveID(this.mLiveID.Text);
            return tmp;
        }

        //-------------------------------------------------------------------------
        // 現在放送中のLV取得
        //-------------------------------------------------------------------------
        private string GetCurrentLive()
        {
            Nico nico = Nico.Instance;

            string result = nico.GetCurrentLive(
                                Properties.Settings.Default.user_id,
                                Properties.Settings.Default.password
                             );

            nico = null;
            return result;
        }
        //-------------------------------------------------------------------------
        // 配信プレイヤー取得
        //-------------------------------------------------------------------------
        private void GetPlayer()
        {
#if DEBUG
            string uri = "http://nicolive.sourceforge.jp/debug/console.swf";
#else
            string uri = "http://nicolive.sourceforge.jp/console.swf";
#endif
            //uri = Application.StartupPath + "\\console.swf";
            try
            {
                mFlash.LoadMovie(0, uri);
                mPlayerLoaded = true;
            }
            catch (Exception e)
            {
                Console.WriteLine("GetPlayer:"+e.Message);
            }
            
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashCall(String iVal)
        {
            try
            {
                mProxy.Call("onRecvData", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine( e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashSetEndTime(int iVal)
        {
            try
            {
                mProxy.Call("setEndTime", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashSetUrl(String iVal)
        {
            try
            {
                mProxy.Call("setUrl", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashSetPublish(String iVal)
        {
            try
            {
                mProxy.Call("setPublish", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashSetTime(String iVal)
        {
            try
            {
                mProxy.Call("setTime", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashへのデータ送信
        //-------------------------------------------------------------------------
        private void FlashAppendLog(String iVal)
        {
            try
            {
                mProxy.Call("appendLog", iVal);
            }
            catch (Exception e)
            {
                Console.WriteLine(e.Message);
            }
        }
        //-------------------------------------------------------------------------
        //Flashからのデータ受信
        //-------------------------------------------------------------------------
        private object onFromFlash(object eventSender,ExternalInterfaceCallEventArgs e )
        {
            Console.WriteLine( e.FunctionCall.FunctionName );
            switch (e.FunctionCall.FunctionName)
            {
                case "liveStop":
                    if (mNico != null && mNico.IsLogin && !CheckStatus(STATUS_FLAGS.DISCONNECT))
                    {
                        mNico.SendOwnerComment(LiveID, "/disconnect", "", mLiveInfo.Token);
                        mNico.LiveStop(LiveID, mLiveInfo.Token);
                    }
                    break;
                case "liveStart":
                    mBouyomi.Talk(mMsg.GetMessage("配信を開始しました"));
                    this.mLastChatTime = DateTime.Now;
                    break;
                case "close":
                    Console.WriteLine("切断されました");
                    break;
                case "ready":
                    mConnectBtn.Enabled = true;
                    mCopyBtn.Enabled = true;
                    mWakutoriBtn.Enabled = true;
                    mBroType.SelectedIndex = (Properties.Settings.Default.use_fme) ? 1 : 0;
                    break;
                case "camera":
                    string cam = (string)e.FunctionCall.Arguments[0];
                    mLiveInfo.Camera = cam;
                    Debug.WriteLine(cam);
                    break;
                case "mic":
                    string mic = (string)e.FunctionCall.Arguments[0];
                    mLiveInfo.Mic = mic;
                    Debug.WriteLine(mic);
                    break;
            }
            return null;
        }    

        //-------------------------------------------------------------------------
        // 来場者数通知
        //-------------------------------------------------------------------------
        private void SpeakVisitor()
        {
            // 読み上げが有効になってない
            if (!this.mVisitorBtn.Checked)
                return;

            // 読み上げる
            int cnt = mVisitorCnt;
            if (cnt <= 0) return;

            if (mTargetVisitorCnt <= cnt)
            {
                string str = String.Format(mMsg.GetMessage("只今の来場者すう、{0}人です"), cnt);
                mBouyomi.Talk(str);

                mTargetVisitorCnt = cnt + 10;
                mTargetVisitorCnt /= 10;
                mTargetVisitorCnt *= 10;
            }
        }

        //-------------------------------------------------------------------------
        // 自動枠取り画面起動
        //-------------------------------------------------------------------------
        private void MakeWakutori(bool iAuto)
        {
            Wakutori mk = new Wakutori();
            mk.MyOwner = this;
            mk.AutoWaku = iAuto;
            mk.Show();
        }

        //-------------------------------------------------------------------------
        // ステータスフラグ追加
        //-------------------------------------------------------------------------
        private void AddStatus(STATUS_FLAGS iStatus)
        {
            mCurStatus |= iStatus;
        }

        //-------------------------------------------------------------------------
        // ステータスフラグ削除
        //-------------------------------------------------------------------------
        private void DelStatus(STATUS_FLAGS iStatus)
        {
            mCurStatus &= ~iStatus;
        }

        //-------------------------------------------------------------------------
        // ステータスフラグチェック
        //-------------------------------------------------------------------------
        private bool CheckStatus(STATUS_FLAGS iStatus)
        {
            return ((mCurStatus & iStatus) == iStatus);
        }
        //-------------------------------------------------------------------------
        // FME配信有効化
        //-------------------------------------------------------------------------
        private void EnableFME(bool iEnable)
        {
            if (mNico.IsLogin && CheckStatus(STATUS_FLAGS.OWN_LIVE))
            {
                FlashCall((iEnable) ? "detach" : "attach");

                if (!iEnable)
                    FlashCall("enable");

                if (iEnable)
                    FlashAppendLog("FME配信に切り替えました");
                else
                    FlashAppendLog("通常配信に切り替えました");

                if (iEnable)
                    mNico.LiveStartFME(mLiveInfo.ID, mLiveInfo.Token);
                else
                    mNico.LiveStart(mLiveInfo.ID, mLiveInfo.Token);
            }
        }

        //-------------------------------------------------------------------------
        // 延長購入
        //-------------------------------------------------------------------------
        public void BuyItem(int iIdx)
        {
            if (mNico != null &&
                CheckStatus(STATUS_FLAGS.OWN_LIVE))
            {
                mBuyItemIdx = iIdx;
                mBuyItemName = mSaleList[iIdx].mLabel;
                AddStatus(STATUS_FLAGS.BUY_ITEM);
                ReleaseExtendItemLock();
            }
        }

        //-------------------------------------------------------------------------
        // 延長購入
        //-------------------------------------------------------------------------
        public void ReleaseExtendItemLock()
        {
            DelStatus(STATUS_FLAGS.EXTEND_ITEM_LOCK);
        }
    }
}
//-------------------------------------------------------------------------
// Main Form
//
// Copyright (c) 金時豆(http://ch.nicovideo.jp/community/co48276)
//-------------------------------------------------------------------------
