package jp.sourceforge.nicoro.swf;

import jp.sourceforge.nicoro.Release;

public abstract class Log {
	/*private*/ static final boolean DEBUG_LOGV = Release.IS_DEBUG && false;
	/*private*/ static final boolean DEBUG_LOGD = Release.IS_DEBUG && true;
	/*private*/ static final String LOG_TAG = "NicoRo";
	
	private static final String MSG_NULL = "(msg=null)";
	
	private static ThreadLocal<StringBuilder> sLogBuffer =
		new ThreadLocal<StringBuilder>() {
		@Override
		protected StringBuilder initialValue() {
			return new StringBuilder(256);
		}
	};

    public static int v(String tag, String msg) {
        return android.util.Log.v(tag, msg == null ? MSG_NULL : msg);
    }
    public static int v(String tag, String msg, Throwable tr) {
        return android.util.Log.v(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int d(String tag, String msg) {
        return android.util.Log.d(tag, msg == null ? MSG_NULL : msg);
    }
    public static int d(String tag, String msg, Throwable tr) {
        return android.util.Log.d(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int i(String tag, String msg) {
        return android.util.Log.i(tag, msg == null ? MSG_NULL : msg);
    }
    public static int i(String tag, String msg, Throwable tr) {
        return android.util.Log.i(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int w(String tag, String msg) {
        return android.util.Log.w(tag, msg == null ? MSG_NULL : msg);
    }
    public static int w(String tag, String msg, Throwable tr) {
        return android.util.Log.w(tag, msg == null ? MSG_NULL : msg, tr);
    }
    public static int e(String tag, String msg) {
        return android.util.Log.e(tag, msg == null ? MSG_NULL : msg);
    }
    public static int e(String tag, String msg, Throwable tr) {
        return android.util.Log.e(tag, msg == null ? MSG_NULL : msg, tr);
    }
    
    public static StringBuilder buf() {
    	StringBuilder sb = sLogBuffer.get();
    	sb.setLength(0);
    	return sb;
    }
}
