
package jp.sourceforge.nicoro;

import java.util.ArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;

public interface ConfigureNgClientInterface extends XmlLoaderInterface {
    public interface EventListener {
        /**
         * ファイル全体の読み込み完了
         * @param client
         */
        public void onFinished(ConfigureNgClientInterface client);
        /**
         * エラー発生
         * @param client
         * @param errorMessage
         */
        public void onOccurredError(ConfigureNgClientInterface client, String errorMessage);
    }

    static final int NG_TYPE_INVALID = -1;
    /** ユーザーID */
    static final int NG_TYPE_ID = 0;
    /** コメント */
    static final int NG_TYPE_WORD = 1;
    /** コマンド */
    static final int NG_TYPE_COMMAND = 2;

    // XML解析データ
    public static class NgClient {
        public int type;
        public String source;

        public NgClient(int t, String s) {
            type = t;
            source = s;
        }
    }

    boolean isNull();

    ArrayList<NgClient> getNgClients();

    void setEventListener(ConfigureNgClientInterface.EventListener eventListener);

    public static class NullObject implements ConfigureNgClientInterface {
        private static final NullObject sInstance = new NullObject();
        public static NullObject getInstance() {
            return sInstance;
        }

        private NullObject() {
        }

        @Override
        public boolean isNull() {
            return true;
        }

        @Override
        public ArrayList<NgClient> getNgClients() {
            return null;
        }

        @Override
        public void setEventListener(EventListener eventListener) {
        }

        @Override
        public void startLoad() {
        }

        @Override
        public void finish() {
        }

        @Override
        public void finishAsync(ExecutorService executorService,
                CallbackMessage<Void, Void> callback) {
            if (callback != null) {
                callback.sendMessageSuccess(null);
            }
        }

        @Override
        public void finishAsync(ExecutorService executorService, CountDownLatch latch) {
            latch.countDown();
        }
    }
}
