package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.Log;
import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.sourceforge.nicoro.MessageChatController;
import jp.sourceforge.nicoro.MessageChatFork;

public class NicoScriptJumpMarker extends NicoScript {
    protected static final String COMMAND_PREFIX = "ジャンプマーカー";

    private final Label mMarker = new Label();

    protected NicoScriptJumpMarker(MessageChatFork chat, String commandMain) {
        super(chat);

        if (!mMarker.setLabel(commandMain)) {
            Log.w(LOG_TAG, Log.buf().append("invalid JumpMarker=")
                    .append(commandMain).toString());
            return;
        }
    }

    @Override
    public void onDraw(MessageChatController controller) {
        controller.addCommandJumpMarker(this);
    }

    public String getMarkerLabel() {
        return mMarker.getLabel();
    }

    public int getVpos() {
        return mChat.getVpos();
    }
}
