package jp.sourceforge.nicoro;

import android.content.res.Configuration;

public class ComputeVideoDisplaySize {
    private int mResultWidth;
    private int mResultHeight;

    public void compute(int videoWidth, int videoHeight,
            int maxWidth, int maxHeight,
            int orientation, boolean fullscreen16_9) {
        int width;
        int height;
        if (orientation == Configuration.ORIENTATION_PORTRAIT) {
            width = maxWidth;
            if (fullscreen16_9 && (videoWidth * 9 > 14 * videoHeight)) {
                // ワイド画面として表示
                height = (width * 9 + 15) / 16;
            } else {
                // 4:3画面として表示
                height = (width * 3 + 3) / 4;
            }
        } else {
            if (fullscreen16_9 && (videoWidth * 9 > 14 * videoHeight)) {
                // ワイド画面として表示
                int tempWidth = (maxHeight * 16 + 8) / 9;
                if (tempWidth <= maxWidth) {
                    height = maxHeight;
                    width = tempWidth;
                } else {
                    width = maxWidth;
                    height = (width * 9 + 15) / 16;
                }
            } else {
                // 4:3画面として表示
                int tempWidth = (maxHeight * 4 + 2) / 3;
                if (tempWidth <= maxWidth) {
                    height = maxHeight;
                    width = tempWidth;
                } else {
                    width = maxWidth;
                    height = (width * 3 + 3) / 4;
                }
            }
        }

        mResultWidth = width;
        mResultHeight = height;
    }

    public int getWidth() {
        return mResultWidth;
    }
    public int getHeight() {
        return mResultHeight;
    }
}
