package jp.sourceforge.nicoro;

//import static jp.sourceforge.nicoro.Log.LOG_TAG;

import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;

import java.io.IOException;
import java.io.InputStream;

public class HttpManager {
    private DefaultHttpClient mClient;
    private HttpHost mHost;
    private HttpUriRequest mUriRequest;
    private HttpResponse mResponse;

    public HttpManager(DefaultHttpClient client, HttpHost host,
            HttpUriRequest uriRequest) {
        mClient = client;
        mHost = host;
        mUriRequest = uriRequest;
    }
    public HttpManager(DefaultHttpClient client, HttpUriRequest uriRequest) {
        this(client, null, uriRequest);
    }

    public HttpResponse execute()
    throws ClientProtocolException, IOException {
        mResponse = null;
        if (mHost == null) {
            mResponse = mClient.execute(mUriRequest);
        } else {
            mResponse = mClient.execute(mHost, mUriRequest);
        }
        return mResponse;
    }

    public InputStream getEntityInputStream()
    throws IllegalStateException, IOException {
        assert mResponse != null;
        HttpEntity entity = mResponse.getEntity();
        if (entity == null) {
            return null;
        }
        return entity.getContent();
    }

    public void abort() {
        Util.abortHttpUriRequest(mUriRequest);
    }

    public static class HttpClientExecuteException extends IOException {
        private static final long serialVersionUID = -141617267951588512L;

        public HttpClientExecuteException() {
            super();
        }

        public HttpClientExecuteException(String detailMessage) {
            super(detailMessage);
        }
    }

    /**
     *
     * @param client
     * @param request
     * @return nullでないこととgetStatusLine()の結果がnullでないことを保証
     * @throws IOException
     * @throws ClientProtocolException
     * @throws HttpClientExecuteException execute()は成功したが戻り値が異常
     */
    public static HttpResponse executeWrapper(HttpClient client,
            HttpUriRequest request) throws IOException, ClientProtocolException,
            HttpClientExecuteException {
        HttpResponse response = client.execute(request);
        if (response == null) {
            throw new HttpClientExecuteException("HttpClient execute failed");
        }
        if (response.getStatusLine() == null) {
            throw new HttpClientExecuteException("HttpReponse has no status");
        }
        return response;
    }

    /**
     *
     * @param client
     * @param host
     * @param request
     * @return nullでないこととgetStatusLine()の結果がnullでないことを保証
     * @throws IOException
     * @throws ClientProtocolException
     * @throws HttpClientExecuteException execute()は成功したが戻り値が異常
     */
    public static HttpResponse executeWrapper(HttpClient client,
            HttpHost host, HttpUriRequest request) throws IOException, ClientProtocolException,
            HttpClientExecuteException {
        HttpResponse response = client.execute(host, request);
        if (response == null) {
            throw new HttpClientExecuteException("HttpClient execute failed");
        }
        if (response.getStatusLine() == null) {
            throw new HttpClientExecuteException("HttpReponse has no status");
        }
        return response;
    }
}
