package jp.sourceforge.nicoro;

import android.content.Context;
import android.util.AttributeSet;
import android.widget.LinearLayout;

public class PlayerInfoMiniLayout extends LinearLayout {
    private LayoutListener mLayoutListener;

    public PlayerInfoMiniLayout(Context context) {
        super(context);
    }

    public PlayerInfoMiniLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    @Override
    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
        if (changed) {
            if (mLayoutListener != null) {
                mLayoutListener.onLayout(this, l, t, r, b);
            }
        }
    }

    public void setLayoutListener(LayoutListener listener) {
        mLayoutListener = listener;
    }
}
