package jp.sourceforge.nicoro.nicoscript;

import jp.sourceforge.nicoro.MessageChatFork;
import junit.framework.TestCase;

public class NicoScriptKeywordJumpTest extends TestCase {
    public void testCallback() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript("＠キーワードジャンプ 合い言葉 sm1", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        FakeMessageChatController fake = new FakeMessageChatController();
        assertNull(fake.scriptKeywordJump);
        assertFalse(fake.calledAddCommandKeywordJump);
        assertFalse(fake.calledRemoveCommandKeywordJump);

        script.onDraw(fake);
        assertEquals(script, fake.scriptKeywordJump);
        assertTrue(fake.calledAddCommandKeywordJump);
        assertFalse(fake.calledRemoveCommandKeywordJump);

        script.onPrepareRemove(fake);
        assertEquals(script, fake.scriptKeywordJump);
        assertTrue(fake.calledRemoveCommandKeywordJump);
    }

    public void testDefault() {
        MessageChatFork chat = new MessageChatFork("", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ 合い言葉 sm1 秘密の動画", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertEquals(NicoScript.UNDEFINED_DEFAULT_TIME, chat.getTime());
        assertTrue(script.match("合い言葉"));
        assertTrue(script.match("合い言葉を述べよ"));
        assertEquals("sm1", script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("秘密の動画", script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
        assertFalse(script.isSaveLocal());
    }

    public void testJumpTime() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ みく #39:39 ｢みっく みく｣", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertEquals(90, chat.getTime());
        assertTrue(script.match("みく"));
        assertNull(script.getJumpToVideoNumber());
        assertEquals(2379, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("みっく みく", script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
    }

    public void testJumpLabel() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ キー #label", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertEquals(90, chat.getTime());
        assertTrue(script.match("キー"));
        assertNull(script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertEquals("label", script.getJumpToLabel());
        assertEquals(NicoScript.UNDEFINED_DEFAULT_JUMP_MESSAGE, script.getJumpMessage());
        assertEquals(-1, script.getJumpStartTimeSecond());
        assertEquals(-1, script.getReturnTimeSecond());
        assertNull(script.getReturnMessage());
    }

    public void testReturn() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ 行きます sm1 移動 部分一致 別窓 3:00 30 戻ります", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertEquals(90, chat.getTime());
        assertTrue(script.match("行きます"));
        assertEquals("sm1", script.getJumpToVideoNumber());
        assertEquals(-1, script.getJumpToSecond());
        assertNull(script.getJumpToLabel());
        assertEquals("移動", script.getJumpMessage());
        assertEquals(180, script.getJumpStartTimeSecond());
        assertEquals(30, script.getReturnTimeSecond());
        assertEquals("戻ります", script.getReturnMessage());
    }

    public void testIsSaveLocal() {
        MessageChatFork chat = new MessageChatFork("@120 local", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ hoge sm1", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertTrue(script.isSaveLocal());
    }

    public void testOption1() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ そんな装備で大丈夫か？ sm1 大丈夫だ、問題ない 部分一致", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertFalse(script.match("大丈夫か？"));
        assertTrue(script.match("そんな装備で大丈夫か？"));
        assertTrue(script.match("ゆっくり「そんな装備で大丈夫か？」"));
    }

    public void testOption2() {
        MessageChatFork chat = new MessageChatFork("@90", 0, 0, 0, null, 0);

        NicoScript ns = NicoScript.createNicoScript(
                "＠キーワードジャンプ そんな装備で大丈夫か？ sm1 大丈夫だ、問題ない 完全一致", chat);
        assertEquals(NicoScriptKeywordJump.class, ns.getClass());

        NicoScriptKeywordJump script = (NicoScriptKeywordJump) ns;
        assertFalse(script.match("大丈夫か？"));
        assertTrue(script.match("そんな装備で大丈夫か？"));
        assertFalse(script.match("ゆっくり「そんな装備で大丈夫か？」"));
    }
}
