package jp.sourceforge.nicoro;

import android.os.Parcel;
import android.os.Parcelable;

/**
 * rational number, fraction
 */
public class Rational implements Parcelable {
	/**
	 * numerator （分子）
	 */
	public int num;
	/**
	 * denominator （分母）
	 */
	public int den;
	
	public Rational() {
		num = 0;
		den = 1;
	}
	
	public Rational(int n, int d) {
		num = n;
		den = d;
	}
	
	public float getDivideFloat() {
		if (den == 0) {
			return 0;
		}
		return (float) num / (float) den;
	}
	public int getDivideInt() {
		if (den == 0) {
			return 0;
		}
		return num / den;
	}
	
	/**
	 * 分数が秒を表しているものとして、ミリ秒単位に変換して取得
	 * @return
	 */
	public int getMs() {
		if (den == 0) {
			return 0;
		}
		return (int) ((long) num * 1000L / den);
	}

	/**
	 * 分数が秒を表しているものとして、10ミリ秒単位に変換して取得
	 * @return
	 */
	public int getVpos() {
		if (den == 0) {
			return 0;
		}
		return (int) ((long) num * 100L / den);
	}

	// Parcelable
	
	@Override
	public int describeContents() {
		return 0;
	}

	@Override
	public void writeToParcel(Parcel dest, int flags) {
		dest.writeInt(num);
		dest.writeInt(den);
	}
	
	public static final Parcelable.Creator<Rational> CREATE =
		new Parcelable.Creator<Rational>() {
			@Override
			public Rational createFromParcel(Parcel source) {
				return new Rational(source);
			}

			@Override
			public Rational[] newArray(int size) {
				return new Rational[size];
			}
		
	};
	
	Rational(Parcel p) {
		num = p.readInt();
		den = p.readInt();
	}
}
