package jp.sourceforge.nicoro;

import android.content.Context;
import android.graphics.Canvas;
import android.util.AttributeSet;
import android.view.View;

public class MessageView extends View {
	private Callback mCallback;
	
	public MessageView(Context context) {
		super(context);
	}
	public MessageView(Context context, AttributeSet attrs) {
		super(context, attrs);
	}
	public MessageView(Context context, AttributeSet attrs, int defStyle) {
		super(context, attrs, defStyle);
	}
	
	public void setCallback(Callback callback) {
		mCallback = callback;
	}
	
	@Override
	protected void onDraw(Canvas canvas) {
		mCallback.drawMessageView(this, canvas);
	}
	
	public static interface Callback {
		public void drawMessageView(MessageView messageView, Canvas canvas);
	}
}
