package jp.sourceforge.nicoro.swf;

import java.io.IOException;
import java.lang.ref.SoftReference;

import jp.sourceforge.nicoro.FailAnalyzeSwfException;

import android.graphics.Bitmap;

public abstract class BitmapLoader {
	protected SoftReference<Bitmap> mBitmap;
	
	public abstract Bitmap load() throws IOException, FailAnalyzeSwfException;
	
	public Bitmap get() throws IOException, FailAnalyzeSwfException {
		Bitmap bitmap;
		if (mBitmap == null) {
			bitmap = null;
		} else {
			bitmap = mBitmap.get();
		}

		if (bitmap == null) {
			bitmap = load();
			mBitmap = new SoftReference<Bitmap>(bitmap);
		}
		return bitmap;
	}
}
