package jp.sourceforge.nicoro;

/**
 * Playerで共通して使用する定数他
 */
public class PlayerConstants {
    public static final String INTENT_NAME_VIDEO_URL = "VIDEO_URL";
    public static final String INTENT_NAME_COOKIE = "COOKIE";
    public static final String INTENT_NAME_VIDEO_NUMBER = "VIDEO_NUMBER";
    public static final String INTENT_NAME_MESSAGE_URL = "MESSAGE_URL";
    public static final String INTENT_NAME_THREAD_ID = "THREAD_ID";
    public static final String INTENT_NAME_USER_ID = "USER_ID";
    public static final String INTENT_NAME_THREAD_KEY = "THREAD_KEY";
    public static final String INTENT_NAME_FORCE_184 = "FORCE_184";
    public static final String INTENT_NAME_COOKIE_USER_SESSION = "COOKIE_USER_SESSION";
    public static final String INTENT_NAME_FORCE_LOW = "FORCE_LOW";

    public static final String INTENT_NAME_LIVE_NUMBER = "LIVE_NUMBER";
    public static final String INTENT_NAME_TITLE = "TITLE";
    public static final String INTENT_NAME_DESCRIPTION = "DESCRIPTION";

    /** コメント取得完了 */
    public static final int MSG_ID_MESSAGE_FINISHED = 0;
    /** コメント取得エラー */
    public static final int MSG_ID_MESSAGE_OCCURRED_ERROR = 1;
    /** 動画情報（getthumbinfo）取得完了 */
    public static final int MSG_ID_THUMBINFO_FINISHED = 2;
    /** 動画情報（getthumbinfo）取得エラー */
    public static final int MSG_ID_THUMBINFO_OCCURRED_ERROR = 3;
    /** 動画ファイル取得エラー */
    public static final int MSG_ID_VIDEO_OCCURRED_ERROR = 4;
    /** 動画ファイル取得進行状況通知 */
    public static final int MSG_ID_VIDEO_NOTIFY_PROGRESS = 5;
    /** 動画の再生時間表示を更新 */
    public static final int MSG_ID_INFO_TIME_UPDATE = 6;
    /** 動画再生中にエラー */
    public static final int MSG_ID_PLAY_ERROR = 7;
    /** 投稿者コメント取得完了 */
    public static final int MSG_ID_MESSAGE_FORK_FINISHED = 8;
    /** 投稿者コメント取得エラー */
    public static final int MSG_ID_MESSAGE_FORK_OCCURRED_ERROR = 9;
    /** SeekBarを有効化 */
    public static final int MSG_ID_ENABLE_SEEK_BAR = 10;
    /** 動画の再生情報表示を更新 */
    public static final int MSG_ID_INFO_PLAY_DATA_UPDATE = 12;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得完了 */
    public static final int MSG_ID_THUMBINFO_FINISHED_NEW = 13;
    /** 動画情報（getthumbinfo）をネットワークから新規に取得でエラー */
    public static final int MSG_ID_THUMBINFO_OCCURRED_ERROR_NEW = 14;
    /** 動画を最後まで再生完了 */
    public static final int MSG_ID_PLAY_FINISHED = 15;
    /** 動画再生完了時のダイアログを表示 */
    public static final int MSG_ID_PLAY_FINISHED_DIALOG = 16;
    /** Playerをタイマーで自動終了 */
    public static final int MSG_ID_AUTO_CLOSE = 17;
    /** 動画ファイル取得完了 */
    public static final int MSG_ID_VIDEO_DOWNLOAD_FINISHED = 18;
    /** 動画ファイルの一定以上のキャッシュ完了 */
    public static final int MSG_ID_VIDEO_CACHED = 19;
    /** 動画ファイル取得開始 */
    public static final int MSG_ID_VIDEO_DOWNLOAD_STARTED = 20;
    /** コメントサーバーへの接続完了 */
    public static final int MSG_ID_LIVE_MESSAGE_CONNECTED = 21;
    /** コメントサーバーへの接続エラー */
    public static final int MSG_ID_LIVE_MESSAGE_OCCURRED_ERROR = 22;
    /** 生放送情報（getplayerstatus）の取得完了 */
    public static final int MSG_ID_GET_PLAYER_STATUS_SUCCEEDED = 23;
    /** 生放送情報（getplayerstatus）の取得エラー */
    public static final int MSG_ID_GET_PLAYER_STATUS_FAILED = 24;
    /** {@link AbstractPlayerFragment}のサブクラスで追加定義するイベントIDのオフセット */
    public static final int MSG_ID_SUB_OFFSET = 0x100;

    public static final int REAL_PLAYER_WIDTH_PX_4_3 = 512;
    public static final int REAL_PLAYER_HEIGHT_PX_4_3 = 384;
//    public static final int REAL_PLAYER_HEIGHT_PX_16_9 = 288;
    public static final int REAL_PLAYER_WIDTH_PX_15_9 = 640;
    public static final int REAL_PLAYER_WIDTH_PX_16_9 = 684; // 682.66

}
