package jp.sourceforge.nicoro;

import android.os.Bundle;

import junit.framework.TestCase;

public class StateManagerTest extends TestCase {

    public void testNormalSequence() {
        StateManager st = new StateManager();

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onDestroy();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertTrue(st.wasDestroyed());
        assertFalse(st.wasRestarted());
    }

    public void testRestored() {
        StateManager st = new StateManager();

        st.onCreate(new Bundle());
        assertTrue(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());
    }

    public void testRestarted() {
        StateManager st = new StateManager();

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onRestart();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertTrue(st.wasRestarted());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertTrue(st.wasRestarted());
    }

    public void testSaveInstanceState() {
        StateManager st = new StateManager();

        st.onCreate(null);
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStart();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onResume();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertTrue(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onPause();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertFalse(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onSaveInstanceState();
        assertFalse(st.wasRestored());
        assertTrue(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onStop();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertFalse(st.wasDestroyed());
        assertFalse(st.wasRestarted());

        st.onDestroy();
        assertFalse(st.wasRestored());
        assertFalse(st.isStarting());
        assertFalse(st.isResuming());
        assertTrue(st.wasSavedInstanceState());
        assertTrue(st.wasDestroyed());
        assertFalse(st.wasRestarted());
    }
}
