package jp.sourceforge.nicoro;

import static jp.sourceforge.nicoro.Log.LOG_TAG;
import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;
import jp.sourceforge.nicoro.StaticRes.*;

import android.app.Activity;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentTransaction;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.LinearLayout;
import android.widget.RadioButton;
import android.widget.RadioGroup;
import android.widget.ScrollView;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Iterator;

public class ListMenuFragment extends Fragment
implements RadioGroup.OnCheckedChangeListener, WebBrowserFragmentStarter,
Handler.Callback {
    private static final boolean DEBUG_LOGV = Release.IS_DEBUG & true;
    private static final boolean DEBUG_LOGD = Release.IS_DEBUG & true;

    private static final int MSG_ID_SCROLL_RADIO_BUTTON_TO_DISPLAY = 0;

    private static final String KEY_DEFAULT_LIST_RADIO_ID = "mDefaultListRadioId";
    private static final String KEY_CHECKED_LIST_RADIO_ID = "checkedListRadioId";

    private LinearLayout mRootListMenu;
    private FrameLayout mFragmentList;
    private RadioGroup mListMenu;
//    private HorizontalScrollView mScrollListMenu;
    private FrameLayout mScrollListMenu;

    private ArrayList<WeakReference<Fragment>> mLists =
        new ArrayList<WeakReference<Fragment>>();

    private CallbackMessage<String, Void> mBrowserStarter;

    private int mLastCheckedId = -1;
    private int mDefaultListRadioId = 0;

    private int mCurrentOrientation = Configuration.ORIENTATION_UNDEFINED;

    private boolean mSavedInstanceState = false;

    private final HandlerWrapper mHandler = new HandlerWrapper(this);

    @Override
    public boolean handleMessage(Message msg) {
        if (isRemoving()) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, Log.buf().append("Fragment is removing. ignore message=")
                        .append(msg.toString()).toString());
            }
            return true;
        }
        switch (msg.what) {
            case MSG_ID_SCROLL_RADIO_BUTTON_TO_DISPLAY:
                RadioButton radioButton = ViewUtil.findViewById(mListMenu,
                        mListMenu.getCheckedRadioButtonId());
                FrameLayout scroll = mScrollListMenu;
                if (radioButton != null && scroll != null
                        && !scrollRadioButonToDisplay(radioButton, scroll)) {
                    // まだViewが表示される前に呼ばれることがあるので、後から再実行
                    scroll.getViewTreeObserver().addOnGlobalLayoutListener
                    (new ViewTreeObserver.OnGlobalLayoutListener() {
                        @Override
                        public void onGlobalLayout() {
                            RadioButton radioButton = ViewUtil.findViewById(mListMenu,
                                    mListMenu.getCheckedRadioButtonId());
                            FrameLayout scroll = mScrollListMenu;
                            if (radioButton != null && scroll != null
                                    && scrollRadioButonToDisplay(radioButton, scroll)) {
                                scroll.getViewTreeObserver().removeGlobalOnLayoutListener(this);
                            }
                        }
                    });
                }
                break;
            default:
                assert false : msg.what;
                break;
        }
        return true;
    }

    @Override
    public View onCreateView(LayoutInflater inflater, ViewGroup container,
            Bundle savedInstanceState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onCreateView").toString());
        }
        mRootListMenu = ViewUtil.inflate(inflater, R.layout.fragment_list_menu,
                container, false);
        View v = mRootListMenu;
        mFragmentList = ViewUtil.findViewById(v, R.id.fragment_list);
        RadioGroup listMenu = ViewUtil.findViewById(v, R.id.list_menu);
        mListMenu = listMenu;
        createRadioButton(inflater, listMenu);
        listMenu.setOnCheckedChangeListener(this);

        mScrollListMenu = (FrameLayout) mListMenu.getParent();

        return v;
    }

    private void createRadioButton(LayoutInflater inflater, RadioGroup listMenu) {
        final int[] id = new int[] {
                R.id.radio_index,
                R.id.radio_ranking,
                R.id.radio_mylist,
                R.id.radio_video_tag,
                R.id.radio_related_video,
                R.id.radio_access_history,
                R.id.radio_bookmarks,
//                R.id.radio_nicorepo,
        };
        final int[] string = new int[] {
                R.string.item_list_menu_index,
                R.string.item_list_menu_ranking,
                R.string.item_list_menu_mylist,
                R.string.item_list_menu_video_tag,
                R.string.item_list_menu_related_video,
                R.string.item_list_menu_access_history,
                R.string.item_list_menu_bookmarks,
//                R.string.item_list_menu_nicorepo,
        };
        for (int i = 0; i < id.length; ++i) {
            RadioButton radioButton = ViewUtil.inflate(inflater,
                    R.layout.fragment_list_menu_radio_button,
                    listMenu, false);
            radioButton.setId(id[i]);
            radioButton.setText(string[i]);
            listMenu.addView(radioButton);
        }
    }

    @Override
    public void onActivityCreated(Bundle savedInstanceState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onActivityCreated").toString());
        }
        super.onActivityCreated(savedInstanceState);

        mCurrentOrientation = getResources().getConfiguration().orientation;

        if (savedInstanceState == null) {
            // 明示的に後からcheckしてFragment生成
            if (mDefaultListRadioId != 0) {
                mListMenu.check(mDefaultListRadioId);
            }
        } else {
            int defaultListRadioId = savedInstanceState.getInt(
                    KEY_DEFAULT_LIST_RADIO_ID, 0);
            if (defaultListRadioId != 0) {
                mDefaultListRadioId = defaultListRadioId;
            }
            // 明示的に後からcheckしてFragment生成
            int checkedListRadioId = savedInstanceState.getInt(
                    KEY_CHECKED_LIST_RADIO_ID, 0);
            if (checkedListRadioId != 0) {
                mListMenu.check(checkedListRadioId);
            }
        }
    }

    @Override
    public void onStart() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onStart").toString());
        }
        super.onStart();
        mSavedInstanceState = false;
    }

    @Override
    public void onResume() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onResume").toString());
        }
        super.onResume();
        mSavedInstanceState = false;

        Activity activity = getActivity();
        if (activity instanceof ListMenuUpdater) {
            Bundle bundle = ((ListMenuUpdater) activity).getExtrasForListMenu();
            if (bundle != null) {
                FragmentManager manager = getFragmentManager();
                BookmarksFragment bookmarks = ViewUtil.findFragmentByTag(manager,
                        string.tag_bookmarks_fragment);
                ListMenuFragment.updateFragmentBookmarks(bundle, bookmarks);
                RelatedVideoFragment relatedVideo = ViewUtil.findFragmentByTag(manager,
                        string.tag_related_video_fragment);
                ListMenuFragment.updateFragmentRelatedVideo(bundle, relatedVideo);
                update(bundle);
            }
        }
    }

    @Override
    public void onPause() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onPause").toString());
        }
        super.onPause();
        // 非表示のFragment削除
        removeHiddenFragments();
        mDefaultListRadioId = mListMenu.getCheckedRadioButtonId();
    }

    @Override
    public void onDetach() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onDetach").toString());
        }
        super.onDetach();
        // 状態おかしくなるので、子Fragmentはいったん全部外す
        // →onDestroy中は状態異常になるので駄目。
        // ListMenuFragmentを手動でremoveして切り替えということもなくなったので、この処理もういらないはず
//        clearChildFragments();
    }

    @Override
    public void onConfigurationChanged(Configuration newConfig) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onConfigurationChanged").toString());
        }
        super.onConfigurationChanged(newConfig);
        int orientation = newConfig.orientation;
        if (mCurrentOrientation != orientation
                && mRootListMenu != null && mListMenu != null) {
            if (!MainFragmentActivity.isDualPane(newConfig)) {
                int lastChecked = mListMenu.getCheckedRadioButtonId();

                // ダミーのレイアウト生成して、入れ替え不可能な部分はパラメータのみ適用
                LayoutInflater inflater = LayoutInflater.from(getActivity());
                ViewGroup container = (ViewGroup) mRootListMenu.getParent();
                LinearLayout dummyRoot = ViewUtil.inflate(inflater,
                        R.layout.fragment_list_menu, container, false);
                FrameLayout dummyFragmentList = ViewUtil.findViewById(
                        dummyRoot, R.id.fragment_list);
                RadioGroup dummyListMenu = ViewUtil.findViewById(
                        dummyRoot, R.id.list_menu);
                FrameLayout newScrollListMenu =
                    (FrameLayout) dummyListMenu.getParent();

                mRootListMenu.setLayoutParams(dummyRoot.getLayoutParams());
                mRootListMenu.setOrientation(dummyRoot.getOrientation());
                mFragmentList.setLayoutParams(dummyFragmentList.getLayoutParams());

                ViewUtil.removeViewFromParent(newScrollListMenu);
                ViewUtil.replaceView(mScrollListMenu, newScrollListMenu);
                mScrollListMenu = newScrollListMenu;

                RadioGroup listMenu = ViewUtil.findViewById(
                        mScrollListMenu, R.id.list_menu);
                mListMenu = listMenu;
                createRadioButton(inflater, listMenu);
                listMenu.setOnCheckedChangeListener(this);
                listMenu.check(lastChecked);
            }

            // XXX 回転中はレイアウトがまだ整っていない場合がある
            mHandler.sendEmptyMessageDelayed(MSG_ID_SCROLL_RADIO_BUTTON_TO_DISPLAY,
                    400L);
        }
        mCurrentOrientation = orientation;
    }

    public void clearChildFragments() {
        if (!getActivity().isFinishing()) {
            FragmentTransaction transaction = getFragmentManager().beginTransaction();
            for (Iterator<WeakReference<Fragment>> it = mLists.iterator(); it.hasNext(); ) {
                Fragment f = it.next().get();
                if (f != null && f.isAdded() && !f.isRemoving()) {
                    transaction.remove(f);
                }
                it.remove();
            }
            transaction.commit();
        }
        mLastCheckedId = -1;
    }

    @Override
    public void onLowMemory() {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onLowMemory").toString());
        }
        super.onLowMemory();
        // 非表示のFragment削除
        // →onSaveInstanceState後に手動でremoveするとIllegalStateException起こすため、
        // システムが削除するのに任せる
//        removeHiddenFragments();
    }

    @Override
    public void onSaveInstanceState(Bundle outState) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onSaveInstanceState").toString());
        }
        super.onSaveInstanceState(outState);
        mSavedInstanceState = true;
        outState.putInt(KEY_DEFAULT_LIST_RADIO_ID, mDefaultListRadioId);
        outState.putInt(KEY_CHECKED_LIST_RADIO_ID, mLastCheckedId);
    }

    private void removeHiddenFragments() {
        if (mSavedInstanceState) {
            if (DEBUG_LOGD) {
                Log.d(LOG_TAG, "after onSaveInstanceState, ignore ListMenuFragment#removeHiddenFragments");
            }
            return;
        }
        FragmentTransaction transaction = getFragmentManager().beginTransaction();
        for (Iterator<WeakReference<Fragment>> it = mLists.iterator(); it.hasNext(); ) {
            Fragment f = it.next().get();
            if (f == null) {
                it.remove();
            } else if (f.isRemoving()) {
                it.remove();
            } else if (f.isHidden()) {
                transaction.remove(f);
                it.remove();
            }
        }
        transaction.commit();
    }

    // RadioGroup.OnCheckedChangeListener

    @Override
    public void onCheckedChanged(RadioGroup group, int checkedId) {
        if (DEBUG_LOGV) {
            Log.v(LOG_TAG, Log.buf().append(getClass().getName())
                    .append(": onCheckedChanged checkdId=").append(checkedId)
                    .toString());
        }
        // 二重に呼ばれることがあるので、前回の値と比較
        if (checkedId == mLastCheckedId) {
            return;
        }
        mLastCheckedId = checkedId;

//        RadioButton radioButton = Util.findViewById(group, checkedId);
//        HorizontalScrollView scroll = mScrollListMenu;
//        if (!scrollRadioButonToDisplay(radioButton, scroll)) {
//            // まだViewが表示される前に呼ばれることがあるので、後から再実行
//            scroll.getViewTreeObserver().addOnGlobalLayoutListener
//            (new ViewTreeObserver.OnGlobalLayoutListener() {
//                @Override
//                public void onGlobalLayout() {
//                    RadioButton radioButton = Util.findViewById(mListMenu,
//                            mListMenu.getCheckedRadioButtonId());
//                    HorizontalScrollView scroll = mScrollListMenu;
//                    if (scrollRadioButonToDisplay(radioButton, scroll)) {
//                        scroll.getViewTreeObserver().removeGlobalOnLayoutListener(this);
//                    }
//                }
//            });
//        }
        mHandler.sendEmptyMessage(MSG_ID_SCROLL_RADIO_BUTTON_TO_DISPLAY);

        FragmentManager manager = getFragmentManager();
        Fragment lastList = null;
        Fragment newList = null;
        String tag = null;
        Intent intent;
        switch (checkedId) {
            case R.id.radio_bookmarks:
                intent = getActivity().getIntent();

                tag = string.tag_bookmarks_fragment;
                lastList = manager.findFragmentByTag(tag);
                BookmarksFragment bookmarks;
                if (lastList == null) {
                    bookmarks = new BookmarksFragment();
                    newList = bookmarks;
                } else {
                    bookmarks = (BookmarksFragment) lastList;
                }
                updateFragmentBookmarks(intent, bookmarks);
                bookmarks.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_access_history:
                tag = string.tag_access_history_fragment;
                lastList = manager.findFragmentByTag(tag);
                AccessHistoryFragment accessHistory;
                if (lastList == null) {
                    accessHistory = new AccessHistoryFragment();
                    newList = accessHistory;
                } else {
                    accessHistory = (AccessHistoryFragment) lastList;
                }
                accessHistory.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_related_video:
                intent = getActivity().getIntent();

                tag = string.tag_related_video_fragment;
                lastList = manager.findFragmentByTag(tag);
                RelatedVideoFragment relatedVideo;
                if (lastList == null) {
                    relatedVideo = new RelatedVideoFragment();
                    newList = relatedVideo;
                } else {
                    relatedVideo = (RelatedVideoFragment) lastList;
                }
                updateFragmentRelatedVideo(intent, relatedVideo);
                relatedVideo.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_ranking:
                tag = string.tag_ranking_fragment;
                lastList = manager.findFragmentByTag(tag);
                RankingFragment ranking;
                if (lastList == null) {
                    ranking = new RankingFragment();
                    newList = ranking;
                } else {
                    ranking = (RankingFragment) lastList;
                }
                ranking.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_video_tag:
                tag = string.tag_video_tag_fragment;
                lastList = manager.findFragmentByTag(tag);
                VideoTagFragment videoTag;
                if (lastList == null) {
                    videoTag = new VideoTagFragment();
                    newList = videoTag;
                } else {
                    videoTag = (VideoTagFragment) lastList;
                }
                videoTag.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_mylist:
                tag = string.tag_mylist_fragment;
                lastList = manager.findFragmentByTag(tag);
                MylistFragment mylist;
                if (lastList == null) {
                    mylist = new MylistFragment();
                    newList = mylist;
                } else {
                    mylist = (MylistFragment) lastList;
                }
                mylist.setBrowserStarterCallback(mBrowserStarter);
                break;
            case R.id.radio_index:
                tag = string.tag_index_fragment;
                lastList = manager.findFragmentByTag(tag);
                IndexFragment index;
                if (lastList == null) {
                    index = new IndexFragment();
                    newList = index;
                } else {
                    index = (IndexFragment) lastList;
                }
                index.setBrowserStarterCallback(mBrowserStarter);
                break;
            case -1:
                return;
            default:
//                assert false : "invalid checkedId: " + checkedId;
                return;
        }

        FragmentTransaction transaction = manager.beginTransaction();
        boolean foundLastList = false;
        for (Iterator<WeakReference<Fragment>> it = mLists.iterator(); it.hasNext(); ) {
            Fragment f = it.next().get();
            if (f == null) {
                it.remove();
            } else if (f == lastList) {
                foundLastList = true;
            } else {
                if (!f.isHidden()) {
                    transaction.hide(f);
                }
            }
        }
        if (lastList != null) {
            assert tag != null;
            assert newList == null;
            if (lastList.getId() != R.id.fragment_list) {
                if (lastList.isAdded()) {
                    transaction.remove(lastList);
                }
                transaction.add(
                        R.id.fragment_list, lastList, tag);
            } else if (!lastList.isAdded()) {
                transaction.add(
                        R.id.fragment_list, lastList, tag);
            }
            transaction.show(lastList).commit();
            if (!foundLastList) {
                mLists.add(new WeakReference<Fragment>(lastList));
            }
        } else if (newList != null) {
            assert tag != null;
            transaction.add(R.id.fragment_list, newList,
                    tag).show(newList).commit();
            mLists.add(new WeakReference<Fragment>(newList));
        }
    }

    public static void updateFragmentBookmarks(Intent intent,
            BookmarksFragment bookmarks) {
        String url = intent.getStringExtra(
                ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_URL);
        String title = intent.getStringExtra(
                ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_TITLE);
        if (!TextUtils.isEmpty(url)) {
            if (bookmarks == null) {
                Log.w(LOG_TAG, "BookmarksFragment is not found");
            } else {
                bookmarks.setAddBookmark(url, title);
            }
        }
    }
    public static void updateFragmentBookmarks(Bundle bundle,
            BookmarksFragment bookmarks) {
        String url = bundle.getString(
                ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_URL);
        String title = bundle.getString(
                ListMenuActivity.INTENT_EXTRA_BOOKMARKS_ADD_TITLE);
        if (!TextUtils.isEmpty(url)) {
            if (bookmarks == null) {
                Log.w(LOG_TAG, "BookmarksFragment is not found");
            } else {
                bookmarks.setAddBookmark(url, title);
            }
        }
    }

    public static void updateFragmentRelatedVideo(Intent intent,
            RelatedVideoFragment relatedVideo) {
        if (intent.hasExtra(ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER)) {
            String videoNumber = intent.getStringExtra(
                    ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER);
            if (!TextUtils.isEmpty(videoNumber)) {
                if (relatedVideo == null) {
                    Log.w(LOG_TAG, "RelatedVideoFragment is not found");
                } else {
                    relatedVideo.setVideoNumber(videoNumber);
                }
            }
        }
    }
    public static void updateFragmentRelatedVideo(Bundle bundle,
            RelatedVideoFragment relatedVideo) {
        if (bundle.containsKey(ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER)) {
            String videoNumber = bundle.getString(
                    ListMenuActivity.INTENT_EXTRA_VIDEO_NUMBER);
            if (!TextUtils.isEmpty(videoNumber)) {
                if (relatedVideo == null) {
                    Log.w(LOG_TAG, "RelatedVideoFragment is not found");
                } else {
                    relatedVideo.setVideoNumber(videoNumber);
                }
            }
        }
    }

    public void update(Intent intent) {
        boolean hasId = intent.hasExtra(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO);
        if (hasId || mDefaultListRadioId == 0) {
            int defaultListRadioId = intent.getIntExtra(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
                    R.id.radio_index);
            mDefaultListRadioId = defaultListRadioId;
            if (hasId && mListMenu != null) {
                mListMenu.check(defaultListRadioId);
            }
        }
    }
    public void update(Bundle bundle) {
        boolean hasId = bundle.containsKey(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO);
        if (hasId || mDefaultListRadioId == 0) {
            int defaultListRadioId = bundle.getInt(ListMenuActivity.INTENT_EXTRA_DEFAULT_LIST_RADIO,
                    R.id.radio_index);
            mDefaultListRadioId = defaultListRadioId;
            if (hasId && mListMenu != null) {
                mListMenu.check(defaultListRadioId);
            }
        }
    }

    @Override
    public void setBrowserStarterCallback(CallbackMessage<String, Void> callback) {
        mBrowserStarter = callback;
        for (Iterator<WeakReference<Fragment>> it = mLists.iterator(); it.hasNext(); ) {
            Fragment f = it.next().get();
            if (f == null) {
                it.remove();
            } else if (f instanceof WebBrowserFragmentStarter) {
                ((WebBrowserFragmentStarter) f).setBrowserStarterCallback(callback);
            }
        }
    }

    private boolean scrollRadioButonToDisplay(RadioButton radioButton,
            FrameLayout scroll) {
        if (scroll instanceof HorizontalScrollView) {
            return scrollRadioButonToDisplayHorizontal(radioButton,
                    (HorizontalScrollView) scroll);
        } else if (scroll instanceof ScrollView) {
            return scrollRadioButonToDisplayVertical(radioButton,
                    (ScrollView) scroll);
        } else {
            throw new IllegalArgumentException(
                    "scroll must be HorizontalScrollView or ScrollView");
        }
    }
    private boolean scrollRadioButonToDisplayHorizontal(RadioButton radioButton,
            HorizontalScrollView scroll) {
        int buttonWidth = radioButton.getWidth();
        int scrollWidth = scroll.getWidth();
        if (buttonWidth == 0 || scrollWidth == 0) {
            // サイズ0はやり直し
            return false;
        }
        int[] buttonLoc = new int[2];
        radioButton.getLocationInWindow(buttonLoc);
        int[] scrollLoc = new int[2];
        scroll.getLocationInWindow(scrollLoc);
        int buttonLeft = buttonLoc[0];
        int scrollLeft = scrollLoc[0];
        int target = 0;
        if (buttonLeft < scrollLeft) {
            target = buttonLeft - scrollLeft;
        } else {
            int buttonRight = buttonLeft + buttonWidth;
            int scrollRight = scrollLeft + scrollWidth;
            if (buttonRight > scrollRight) {
                target = buttonRight - scrollRight;
            }
        }
        if (target != 0) {
            scroll.smoothScrollBy(target, 0);
        }
        return true;
    }
    private boolean scrollRadioButonToDisplayVertical(RadioButton radioButton,
            ScrollView scroll) {
        int buttonHeight = radioButton.getHeight();
        int scrollHeight = scroll.getHeight();
        if (buttonHeight == 0 || scrollHeight == 0) {
            // サイズ0はやり直し
            return false;
        }
        int[] buttonLoc = new int[2];
        radioButton.getLocationInWindow(buttonLoc);
        int[] scrollLoc = new int[2];
        scroll.getLocationInWindow(scrollLoc);
        int buttonTop = buttonLoc[1];
        int scrollTop = scrollLoc[1];
        int target = 0;
        if (buttonTop < scrollTop) {
            target = buttonTop - scrollTop;
        } else {
            int buttonBottom = buttonTop + buttonHeight;
            int scrollBottom = scrollTop + scrollHeight;
            if (buttonBottom > scrollBottom) {
                target = buttonBottom - scrollBottom;
            }
        }
        if (target != 0) {
            scroll.smoothScrollBy(0, target);
        }
        return true;
    }
}
