package jp.sourceforge.nicoro;

import android.app.Activity;
import android.content.res.Resources;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AnalogClock;

import jp.gr.java_conf.shiseissi.commonlib.ViewUtil;

public class PlayerInfoViews {
//    private VariableLabelView mInfoClock;
    private VariableLabelView mInfoCountPlay;
    private VariableLabelView mInfoCountComment;
    /** nullの可能性あり */
    private VariableLabelView mInfoCountMylist;
    private VariableLabelView mInfoTitle;
    private VariableLabelView mInfoDescription;
    private VariableLabelView mInfoPlayData;
    private VariableLabelView mInfoTime;
    /** nullの可能性あり */
    private VariableLabelView mInfoSheet;
    private AnalogClock mInfoClock;
    private ViewGroup mPlayerInfo;

    private Resources mRes;

    public void initializeView(Activity activity) {
        View root = activity.getWindow().getDecorView();
        initializeView(root);
    }

    public void initializeView(View root) {
        mRes = root.getResources();

        mInfoClock = ViewUtil.findViewById(root, R.id.info_clock);
        mInfoCountPlay = ViewUtil.findViewById(root, R.id.info_count_play);
        mInfoCountComment = ViewUtil.findViewById(root, R.id.info_count_comment);
        mInfoCountMylist = ViewUtil.findViewById(root, R.id.info_count_mylist);
        mInfoTime = ViewUtil.findViewById(root, R.id.info_time);
        mInfoTitle = ViewUtil.findViewById(root, R.id.info_title);
        mInfoDescription = ViewUtil.findViewById(root, R.id.info_description);
        mInfoPlayData = ViewUtil.findViewById(root, R.id.info_play_data);
        mPlayerInfo = ViewUtil.findViewById(root, R.id.player_info);
        mInfoSheet = ViewUtil.findViewById(root, R.id.info_sheet);
    }

    public void copyLayoutParamsFrom(ViewGroup src) {
        ViewUtil.copyLayoutParamsById(mInfoClock, src);
        ViewUtil.copyLayoutParamsById(mInfoCountPlay, src);
        ViewUtil.copyLayoutParamsById(mInfoCountComment, src);
        if (mInfoCountMylist != null) {
            ViewUtil.copyLayoutParamsById(mInfoCountMylist, src);
        }
        ViewUtil.copyLayoutParamsById(mInfoTime, src);
        ViewUtil.copyLayoutParamsById(mInfoTitle, src);
        ViewUtil.copyLayoutParamsById(mInfoDescription, src);
        ViewUtil.copyLayoutParamsById(mInfoPlayData, src);
        ViewUtil.copyLayoutParamsById(mPlayerInfo, src);
        if (mInfoSheet != null) {
            ViewUtil.copyLayoutParamsById(mInfoSheet, src);
        }
    }

    public void setCountPlay(int count) {
        mInfoCountPlay.getTextBuilderWithClear()
            .append(mRes.getString(R.string.info_count_play))
            .append(count);
        mInfoCountPlay.notifyUpdateText();
    }
    public void setLiveCountWatch(String count) {
        mInfoCountPlay.getTextBuilderWithClear()
            .append(mRes.getString(R.string.info_live_count_watch))
            .append(count);
        mInfoCountPlay.notifyUpdateText();
    }

    public void setCountComment(int count) {
        mInfoCountComment.getTextBuilderWithClear()
            .append(mRes.getString(R.string.info_count_comment))
            .append(count);
        mInfoCountComment.notifyUpdateText();
    }
    public void setLiveCountComment(String count) {
        mInfoCountComment.getTextBuilderWithClear()
            .append(mRes.getString(R.string.info_live_count_comment))
            .append(count);
        mInfoCountComment.notifyUpdateText();
    }

    public void setCountMylist(int count) {
        if (mInfoCountMylist == null) {
            return;
        }
        mInfoCountMylist.getTextBuilderWithClear()
            .append(mRes.getString(R.string.info_count_mylist))
            .append(count);
        mInfoCountMylist.notifyUpdateText();
    }

    public void setTitle(String text) {
        mInfoTitle.setText(text);
    }

    public void setDescription(String text) {
        mInfoDescription.setText(text);
    }

    public void setSheet(String text) {
        if (mInfoSheet != null) {
            mInfoSheet.setText(text);
        }
    }

    public void setPlayData(PlayDataAppender appender) {
        StringBuilder builderInfoPlayData = mInfoPlayData.getTextBuilderWithClear();
        builderInfoPlayData.append(mRes.getString(R.string.info_play_data_pre));
        appender.appendMovieType(builderInfoPlayData);
        builderInfoPlayData.append(' ');
        appender.appendVideoResolution(builderInfoPlayData).append(' ');
        appender.appendPlayerInfo(builderInfoPlayData);
        mInfoPlayData.notifyUpdateText();
    }

    /**
     *
     * @param appender
     * @return 文字列生成後のStringBuilder
     */
    public StringBuilder setTime(TimeAppender appender) {
        StringBuilder infoTimeData = mInfoTime.getTextBuilderWithClear();
        appender.appendCurrentPlayTime(infoTimeData);
        if (appender.hasTotalPlayTime()) {
            infoTimeData.append('/');
            appender.appendTotalPlayTime(infoTimeData);
        }
        mInfoTime.notifyUpdateText();
        return infoTimeData;
    }

    public ViewGroup getInfoView() {
        return mPlayerInfo;
    }
    public View getTimeView() {
        return mInfoTime;
    }

    public interface PlayDataAppender {
        StringBuilder appendMovieType(StringBuilder builder);
        StringBuilder appendVideoResolution(StringBuilder builder);
        StringBuilder appendPlayerInfo(StringBuilder builder);
    }

    public interface TimeAppender {
        StringBuilder appendCurrentPlayTime(StringBuilder builder);
        StringBuilder appendTotalPlayTime(StringBuilder builder);
        boolean hasTotalPlayTime();
    }
}
