package jp.sourceforge.nicoro;

import android.app.IntentService;
import android.content.Context;
import android.content.Intent;

public class VideoCacheNotifyService extends IntentService {
    private static final String ACTION_CANCEL_NOTIFICATION_FINISHED_CACHE =
        "jp.sourceforge.nicoro.intent.action.CANCEL_NOTIFICATION_FINISHED_CACHE";

    public VideoCacheNotifyService() {
        super("VideoCacheNotifyService");
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        if (intent == null) {
            return;
        }
        String action = intent.getAction();
        if (ACTION_CANCEL_NOTIFICATION_FINISHED_CACHE.equals(action)) {
            NotificationController nc = NotificationController.getInstance(this);
            nc.cancelAllFinishedCache();
        }
    }

    public static Intent createIntentDeleteNotificationFinishCache(Context context) {
        Intent intent = new Intent(context, VideoCacheNotifyService.class)
            .setAction(ACTION_CANCEL_NOTIFICATION_FINISHED_CACHE);
        return intent;
    }
}
