package jp.gr.java_conf.shiseissi.commonlib;

import java.lang.ref.SoftReference;

/**
 * キャッシュ用途向け弱参照／強参照切り替えクラス
 *
 * @param <T>
 * @author shisei
 */
public class CacheReference<T> {
    private SoftReference<T> mWeak;
    private T mStrength;

    /**
     * @param ref 参照
     */
    public CacheReference(T ref) {
        reset(ref);
    }

    /**
     * 指定した参照で再設定
     * @param ref 参照
     */
    public void reset(T ref) {
        mWeak = new SoftReference<T>(ref);
        mStrength = ref;
    }

    /**
     * 弱参照に切り替える
     */
    public void weaken() {
        mStrength = null;
    }

    /**
     * 強参照に切り替える
     * @return 強参照。GC済みの場合はnull
     */
    public T strengthen() {
        mStrength = mWeak.get();
        return mStrength;
    }

    /**
     * 弱参照／強参照を切り替えずに参照を取得する
     * @return 参照。GC済みの場合はnull
     */
    public T get() {
        return mWeak.get();
    }

    /**
     * 強参照状態か確認する
     * @return
     */
    public boolean isStrength() {
        return mStrength != null;
    }
}
