/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.*;
import java.util.List;
import java.util.ArrayList;
import java.util.Iterator;

/**
 * lXgvpeBB<p>
 * lXgvpeBɃANZX邽߂{@link Property}B<br>
 * ȉ̂悤ȃL[tvpeBɃANZX^CvZ[tȃR[hB<br>
 * <pre>
 *   Fuga propValue = obj.getHoge().getFuga();
 *   obj.getHoge().setFuga(propValue);
 * </pre>
 * lXgvpeBgŁÃR[h<br>
 * <pre>
 *   NestedPropery prop = new NestedPropery(new SimpleProperty("hoge"), new SimpleProperty("fuga"));
 *   Object propValue = prop.getProperty(obj);
 *   prop.setProperty(propValue);
 * </pre>
 * ƂR[hɒu鎖łB<br>
 * ̃R[h́A璷ɂȂĂ邪AΏۂƂȂBeaň^⃁\bh^CvZ[tɏȂIȃR[hɂȂĂB<br>
 * <p>
 * ̃lXgvpeBł́Aȉ̂悤BeañvpeBɑ΂ANZX@pӂĂB<br>
 * <table border="1">
 *   <tr bgcolor="#CCCCFF"><th rowspan="3">ANZX@</th><th>Java\</th><th rowspan="3">vpeB\</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeB擾</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>vpeBݒ</th></tr>
 *   <tr><td rowspan="2">lXgvpeB</td><td>bean.getHoge().getFuga()</td><td rowspan="2">hoge.fuga</td></tr>
 *   <tr><td>bean.getHoge().setFuga(value)</td></tr>
 * </table>
 * lXgΏۂ̂Q̃vpeB́A{@link Property}C^tF[XĂΗǂAPvpeBACfbNXvpeBA}bvvpeBAlXgvpeB̂łǂB<br>
 *
 * @author M.Takata
 */
public class NestedProperty implements Property, Comparable<Property>, java.io.Serializable{
    
    private static final long serialVersionUID = -8976001636216478152L;
    
    private static final String MSG_00001 = "Illegal NestedProperty : ";
    private static final String MSG_00002 = "Arguments is null.";
    
    /**
     * lXgvpeBB<p>
     */
    protected Property thisProperty;
    
    /**
     * lXgvpeBB<p>
     */
    protected Property nestProperty;
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂ̃tOB<p>
     * truȅꍇ́AOthrowȂBftHǵAfalseB<br>
     */
    protected boolean isIgnoreNullProperty;
    
    /**
     * ̃lXgvpeB𐶐B<p>
     */
    public NestedProperty(){
    }
    
    /**
     * w肵Q̃vpeBlXglXgvpeB𐶐B<p>
     *
     * @param prop lXgvpeB
     * @param nestProp lXgvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public NestedProperty(Property prop, Property nestProp)
     throws IllegalArgumentException{
        if(prop == null || nestProp == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        thisProperty = prop;
        nestProperty = nestProp;
    }
    
    /**
     * lXgvpeBݒ肷B<p>
     * 
     * @param prop lXgvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setThisProperty(Property prop) throws IllegalArgumentException{
        if(prop == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        thisProperty = prop;
    }
    
    /**
     * lXgŏ̃vpeB擾B<p>
     * 
     * @return lXgŏ̃vpeB
     */
    public Property getFirstThisProperty(){
        return getFirstThisProperty(thisProperty);
    }
    
    private Property getFirstThisProperty(Property prop){
        if(prop instanceof NestedProperty){
            return getFirstThisProperty(
                ((NestedProperty)prop).getThisProperty()
            );
        }
        return prop;
    }
    
    /**
     * lXgvpeB擾B<p>
     * 
     * @return lXgvpeB
     */
    public Property getThisProperty(){
        return thisProperty;
    }
    
    /**
     * lXgvpeBݒ肷B<p>
     * 
     * @param nestProp lXgvpeB
     * @exception IllegalArgumentException nullw肵ꍇ
     */
    public void setNestedProperty(Property nestProp)
     throws IllegalArgumentException{
        if(nestProp == null){
            throw new IllegalArgumentException(MSG_00002);
        }
        nestProperty = nestProp;
    }
    
    /**
     * lXgvpeB擾B<p>
     * 
     * @return lXgvpeB
     */
    public Property getNestedProperty(){
        return nestProperty;
    }
    
    /**
     * w肵vpeB͂B<p>
     * Ŏw\ȕ́A<br>
     * &nbsp;lXgvpeB.lXgvpeB<br>
     * łB<br>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    @Override
    public void parse(String prop) throws IllegalArgumentException{
        final int index = prop.indexOf('.');
        if(index == -1 || index == 0 || index == prop.length() - 1){
            throw new IllegalArgumentException(MSG_00001 + prop);
        }
        thisProperty = PropertyFactory.createProperty(prop.substring(0, index));
        nestProperty = PropertyFactory.createProperty(
            prop.substring(index + 1)
        );
    }
    
    @Override
    public Class<?> getPropertyType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        final Object thisObj = thisProperty.getProperty(obj);
        if(thisObj == null){
            if(isIgnoreNullProperty){
                return Object.class;
            }else{
                throw new NullNestPropertyException(
                    obj.getClass(),
                    thisProperty.getPropertyName()
                );
            }
        }else{
            return nestProperty.getPropertyType(thisObj);
        }
    }
    
    @Override
    public Type getPropertyGenericType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        final Object thisObj = thisProperty.getProperty(obj);
        if(thisObj == null){
            if(isIgnoreNullProperty){
                return Object.class;
            }else{
                throw new NullNestPropertyException(
                    obj.getClass(),
                    thisProperty.getPropertyName()
                );
            }
        }else{
            return nestProperty.getPropertyGenericType(thisObj);
        }
    }
    
    @Override
    public boolean isReadable(Object obj){
        Object thisObj = null;
        try{
            thisObj = thisProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        if(thisObj == null){
            return false;
        }else{
            return nestProperty.isReadable(thisObj);
        }
    }
    
    @Override
    public boolean isWritable(Object obj, Class<?> clazz){
        Object thisObj = null;
        try{
            thisObj = thisProperty.getProperty(obj);
        }catch(NoSuchPropertyException e){
            return false;
        }catch(InvocationTargetException e){
            return false;
        }
        if(thisObj == null){
            return false;
        }else{
            return nestProperty.isWritable(thisObj, clazz);
        }
    }
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NullNestPropertyException lXgvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException{
        final Object thisObj = thisProperty.getProperty(obj);
        if(thisObj == null){
            if(isIgnoreNullProperty){
                return null;
            }else{
                throw new NullNestPropertyException(
                    obj.getClass(),
                    thisProperty.getPropertyName()
                );
            }
        }else{
            return nestProperty.getProperty(thisObj);
        }
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NullNestPropertyException lXgvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        setProperty(obj, null, value);
    }
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NullNestPropertyException lXgvpeBAnull̏ꍇ
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    @Override
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException{
        final Object thisObj = thisProperty.getProperty(obj);
        if(thisObj == null){
            throw new NullNestPropertyException(
                obj.getClass(),
                thisProperty.getPropertyName()
            );
        }else{
            nestProperty.setProperty(thisObj, type, value);
        }
    }
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return lXgvpeB.lXgvpeB
     */
    @Override
    public String getPropertyName(){
        return thisProperty.getPropertyName()
            + '.' + nestProperty.getPropertyName();
    }
    
    @Override
    public void setIgnoreNullProperty(boolean isIgnore){
        isIgnoreNullProperty = isIgnore;
        if(thisProperty != null){
            thisProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
        if(nestProperty != null){
            nestProperty.setIgnoreNullProperty(isIgnoreNullProperty);
        }
    }
    
    @Override
    public boolean isIgnoreNullProperty(){
        return isIgnoreNullProperty;
    }
    
    /**
     * lXgɃvpeBJԂqԂB<p>
     *
     * @return lXgɃvpeBJԂq
     */
    public Iterator<Property> iterator(){
        final List<Property> list = new ArrayList<Property>();
        NestedProperty nested = this;
        do{
            list.add(0, nested.getNestedProperty());
            Property prop = getThisProperty();
            if(prop instanceof NestedProperty){
                nested = (NestedProperty)prop;
            }else{
                list.add(0, prop);
                nested = null;
            }
        }while(nested != null);
        
        return list.iterator();
    }
    
    /**
     * ̃lXgvpeB̕\擾B<p>
     *
     * @return NestedProperty{vpeB.lXgvpeB}
     */
    @Override
    public String toString(){
        return "NestedProperty{" + thisProperty.toString()
            + '.' + nestProperty.toString() + '}';
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ܂B <p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return Ɏw肳ꂽIuWFNgƂ̃IuWFNgꍇ trueAłȂꍇ falseB
     */
    @Override
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(!(obj instanceof NestedProperty)){
            return false;
        }
        final NestedProperty comp = (NestedProperty)obj;
        if(thisProperty == null && comp.thisProperty != null
            || thisProperty != null && comp.thisProperty == null){
            return false;
        }else if(thisProperty != null && comp.thisProperty != null
            && !thisProperty.equals(comp.thisProperty)){
            return false;
        }
        if(nestProperty == null && comp.nestProperty == null){
            return true;
        }else if(nestProperty == null){
            return false;
        }else{
            return nestProperty.equals(comp.nestProperty);
        }
    }
    
    /**
     * nbVl擾B<p>
     *
     * @return nbVl
     */
    @Override
    public int hashCode(){
        return (thisProperty == null ? 0 : thisProperty.hashCode()) + (nestProperty == null ? 0 : nestProperty.hashCode()) + 3;
    }
    
    /**
     * ̃IuWFNgƎw肳ꂽIuWFNg̏rB<p>
     *
     * @param obj rΏۂ̃IuWFNg
     * @return ̃IuWFNgw肳ꂽIuWFNg菬ꍇ͕̐Aꍇ̓[A傫ꍇ͐̐
     */
    @SuppressWarnings("unchecked")
    @Override
    public int compareTo(Property obj){
        if(obj == null){
            return 1;
        }
        if(!(obj instanceof NestedProperty)){
            return 1;
        }
        final NestedProperty comp = (NestedProperty)obj;
        if(thisProperty == null && comp.thisProperty != null){
            return -1;
        }else if(thisProperty != null && comp.thisProperty == null){
            return 1;
        }else if(thisProperty != null && comp.thisProperty != null){
            if(thisProperty instanceof Comparable){
                final int val = ((Comparable<Property>)thisProperty).compareTo(comp.thisProperty);
                if(val != 0){
                    return val;
                }
            }else{
                return -1;
            }
        }
        if(nestProperty == null && comp.nestProperty == null){
            return 0;
        }else if(nestProperty == null){
            return -1;
        }else{
            if(nestProperty instanceof Comparable){
                return ((Comparable<Property>)nestProperty).compareTo(comp.nestProperty);
            }else{
                return -1;
            }
        }
    }
}
