/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.beans;

import java.lang.reflect.*;

/**
 * BeañvpeBɔėpIɃANZX邽߂̃C^tF[XB<p>
 *
 * @author M.Takata
 */
public interface Property{
    
    /**
     * ̃vpeB\vpeB擾B<p>
     *
     * @return vpeB
     */
    public String getPropertyName();
    
    /**
     * w肵IuWFNgÃvpeB\vpeB^擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeB^
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public Class<?> getPropertyType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException;
    
    /**
     * w肵IuWFNgÃvpeB\vpeB̌^擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeB̌^
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public Type getPropertyGenericType(Object obj)
     throws NoSuchPropertyException, InvocationTargetException;
    
    /**
     * w肵IuWFNgÃvpeB\vpeBl擾B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public Object getProperty(Object obj)
     throws NoSuchPropertyException, InvocationTargetException;
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param value ݒ肷vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public void setProperty(Object obj, Object value)
     throws NoSuchPropertyException, InvocationTargetException;
    
    /**
     * w肵IuWFNgɁÃvpeB\vpeBlݒ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param type vpeB̌^
     * @param value ݒ肷vpeBl
     * @exception NoSuchPropertyException w肳ꂽBeanÃvpeB\ANZX\ȃvpeBĂȂꍇ
     * @exception InvocationTargetException w肳ꂽBeañANZTĂяoʁAOthrowꂽꍇ
     */
    public void setProperty(Object obj, Class<?> type, Object value)
     throws NoSuchPropertyException, InvocationTargetException;
    
    /**
     * w肵vpeB͂B<p>
     *
     * @param prop vpeB
     * @exception IllegalArgumentException w肳ꂽvpeB̃vpeBIuWFNg͂łȂꍇ
     */
    public void parse(String prop) throws IllegalArgumentException;
    
    /**
     * ǂݍ݉\ǂ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @return ǂݍ݉\ȏꍇtrue
     */
    public boolean isReadable(Object obj);
    
    /**
     * ݉\ǂ肷B<p>
     *
     * @param obj ΏۂƂȂBean
     * @param clazz ݒ肷vpeB̌^
     * @return ݉\ȏꍇtrue
     */
    public boolean isWritable(Object obj, Class<?> clazz);
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isIgnore nullQƂ̎ɗOthrowȂꍇtrue
     */
    public void setIgnoreNullProperty(boolean isIgnore);
    
    /**
     * nullQƂ̃vpeB擾gpƂꍇɁAOthrow邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAnullQƂ̎ɗOthrowȂ
     */
    public boolean isIgnoreNullProperty();
}
