/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.util.Set;
import java.net.URL;

/**
 * {@link DefaultServiceLoaderService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see DefaultServiceLoaderService
 */
public interface DefaultServiceLoaderServiceMBean extends ServiceBaseMBean{
    
    /**
     * T[rX`XMLt@CXL[}`Ō؂邩ǂw肷B<p>
     * ftHgł́A؂ȂB<br>
     *
     * @param validate ؂ꍇtrueB
     */
    public void setValidate(boolean validate);
    
    /**
     * T[rX`XMLt@CXL[}`Ō؂邩ǂ𒲂ׂB<p>
     *
     * @return ؂ꍇtrueB
     */
    public boolean isValidate();
    
    /**
     * ܂łɃ[hT[rXSĐɊJnłĂ邩`FbN邩ǂݒ肷B<p>
     * ̑trueɂĂƁAServiceLoader̋NɁA{@link ServiceManagerFactory#checkLoadManagerCompleted()}ĂяoB
     *
     * @param isCheck `FbNꍇtrue
     */
    public void setCheckLoadManagerCompleted(boolean isCheck);
    
    /**
     * ܂łɃ[hT[rXSĐɊJnłĂ邩`FbN邩ǂ𒲂ׂB<p>
     *
     * @return `FbNꍇtrue
     */
    public boolean isCheckLoadManagerCompleted();
    
    /**
     * w肵}l[W̃T[rXSĐɊJnłĂ邩`FbN邩ǂݒ肷B<p>
     * ̑w肷ƁAServiceLoader̋NɁA{@link ServiceManagerFactory#checkLoadManagerCompletedBy(Set)}ĂяoB
     *
     * @param managerNames `FbN}l[W̏W
     */
    public void setCheckLoadManagerCompletedBy(String[] managerNames);
    
    /**
     * T[rXSĐɊJnłĂ邩`FbN}l[W̏W擾B<p>
     *
     * @return `FbN}l[W̏W
     */
    public String[] getCheckLoadManagerCompletedBy();
    
    /**
     * &lt;manager&gt;vf\{@link ServiceManager}C^tF[X̎NXݒ肷B<p>
     * NX́ASCŐݒ肷B<br>
     * ܂Aݒ肵Ȃꍇ́AftHg̎NXgpBftHǵAjp.ossc.nimbus.core.ServiceManagerImplłB<br>
     *
     * @param className ServiceManagerC^tF[X̎NX
     * @exception ClassNotFoundException w肵NX̃NXȂꍇ
     * @exception IllegalArgumentException w肵NX̃NXServiceManagerC^tF[XĂȂꍇ
     * @see #getServiceManagerClassName()
     * @see ServiceManager
     */
    public void setServiceManagerClassName(String className)
     throws ClassNotFoundException, IllegalArgumentException;
    
    /**
     * &lt;manager&gt;vf\{@link ServiceManager}C^tF[X̎NX擾B<p>
     *
     * @return ServiceManagerC^tF[X̎NX
     * @see #setServiceManagerClassName(String)
     * @see ServiceManager
     */
    public String getServiceManagerClassName();
    
    /**
     * T[rX`t@CURLݒ肷B<p>
     *
     * @param url T[rX`t@CURL
     * @exception IllegalArgumentException w肳ꂽURLLURLłȂꍇ
     * @see #getServiceURL()
     */
    public void setServiceURL(URL url) throws IllegalArgumentException;
    
    /**
     * T[rX`t@CURL擾B<p>
     *
     * @return T[rX`t@CURL
     * @see #setServiceURL(URL)
     */
    public URL getServiceURL();
    
    /**
     * T[rX`t@C̃pXݒ肷B<p>
     * Ŏw肳ꂽpX́Aȉ̎菇URLɕύXāA{@link #setServiceURL(URL)}B<br>
     * pXURLΐAȉ̏ōsB<br>
     * <ol>
     *   <li>w肳ꂽpXnullA܂͋󕶎̏ꍇAftHgURLiqj</li>
     *   <li>w肳ꂽpX[Jt@CƂđ݂ꍇA[JpXURLɕϊURL</li>
     *   <li>w肳ꂽpX̃NX[hNX[_̃\[XƂđ݂ꍇAURL</li>
     *   <li>LSĂɓĂ͂܂ȂꍇAOthrowB</li>
     * </ol>
     * ftHgURĽ́Aȉ̏ōsB<br>
     * <ol>
     *   <li>VXevpeBjp.ossc.nimbus.service.urlŎw肳ꂽlAL̃pXURLϊURLɕϊl</li>
     *   <li>̃NX̃NXt@C[hꂽNXpXォAnimbus-service.xml{@link ClassLoader#getResource(String)}Ń\[XƂĎ擾URLB̃NX̃NXt@CJart@CɊi[Ăꍇ́AJart@CƓpXnimbus-service.xmlURL</li>
     * </ol>
     *
     * @param path T[rX`t@C̃pX
     * @exception IllegalArgumentException w肳ꂽpXLȃpXłȂꍇ
     * @see #setServiceURL(URL)
     */
    public void setServicePath(String path) throws IllegalArgumentException;
    
    public void setDocumentBuilderFactoryClassName(String name);
    public String getDocumentBuilderFactoryClassName();
}