/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.core;

import java.io.*;
import java.util.*;
import org.w3c.dom.*;

/**
 * \bhs`&lt;invoke&gt;vf^f[^B<p>
 * T[rX`t@C&lt;invoke&gt;vfɋLqꂽei[郁^f[^ReiłB<p>
 *
 * @author M.Takata
 * @see <a href="nimbus-service_2_0.xsd">T[rX`t@CXL[}`</a>
 */
public class InvokeMetaData extends MetaData
 implements Serializable{
    
    private static final long serialVersionUID = 3183679039637608032L;
    
    /**
     * &lt;invoke&gt;vf̗vfB<p>
     */
    public static final String INVOKE_TAG_NAME = "invoke";
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;target&gt;vf̗vfB<p>
     */
    public static final String TARGET_TAG_NAME = "target";
    
    protected static final String NAME_ATTRIBUTE_NAME = "name";
    protected static final String CALL_STATE_ATTRIBUTE_NAME = "callState";
    
    protected String name;
    
    protected final List<ArgumentMetaData> arguments = new ArrayList<ArgumentMetaData>();
    
    protected String callState = Service.State.CREATED.toString();
    protected Service.State callStateValue = Service.State.CREATED;
    protected MetaData target;
    
    /**
     * evf̃^f[^CX^X𐶐B<p>
     * 
     * @param parent evf̃^f[^
     */
    public InvokeMetaData(MetaData parent){
        super(parent);
    }
    
    /**
     * &lt;invoke&gt;vfname̒l擾B<p>
     * 
     * @return name̒l
     */
    public String getName(){
        return name;
    }
    
    /**
     * &lt;invoke&gt;vfname̒lݒ肷B<p>
     * 
     * @param name name̒l
     */
    public void setName(String name){
        this.name = name;
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;target&gt;vfŎw肷郁\bhĂяoΏۂ擾B<p>
     * 
     * @return qvf&lt;target&gt;vfŎw肷郁\bhĂяoΏ
     */
    public MetaData getTarget(){
        return target;
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;target&gt;vfŎw肷郁\bhĂяoΏۂݒ肷B<p>
     * 
     * @param target qvf&lt;target&gt;vfŎw肷郁\bhĂяoΏ
     */
    public void setTarget(MetaData target){
        this.target = target;
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}̏W擾B<p>
     *
     * @return qvf&lt;argument&gt;vf\ArgumentMetaDatȁW
     */
    public List<ArgumentMetaData> getArguments(){
        return arguments;
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}ǉB<p>
     *
     * @param arg qvf&lt;argument&gt;vf\ArgumentMetaData
     */
    public void addArgument(ArgumentMetaData arg){
        arguments.add(arg);
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}폜B<p>
     *
     * @param arg qvf&lt;argument&gt;vf\ArgumentMetaData
     */
    public void removeArgument(ArgumentMetaData arg){
        arguments.remove(arg);
    }
    
    /**
     * &lt;invoke&gt;vf̎qvf&lt;argument&gt;vf\{@link ArgumentMetaData}Sč폜B<p>
     */
    public void clearArguments(){
        arguments.clear();
    }
    
    /**
     * &lt;invoke&gt;vfcallState̒l擾B<p>
     * 
     * @return callState̒l
     */
    public String getCallState(){
        return callState;
    }
    
    /**
     * &lt;invoke&gt;vfcallState̒lݒ肷B<p>
     * 
     * @param state callState̒l
     */
    public void setCallState(String state){
        callStateValue = Service.State.toState(state);
        callState = state;
    }
    
    /**
     * &lt;invoke&gt;vfcallStatestatel擾B<p>
     * 
     * @return callStatestatel
     */
    public Service.State getCallStateValue(){
        return callStateValue;
    }
    
    /**
     * &lt;invoke&gt;vfElementp[XāAg̏Ayюqvf̃^f[^̐sB<p>
     *
     * @param element &lt;invoke&gt;vfElement
     * @exception DeploymentException &lt;invoke&gt;vf̉́Ǎʂɂ郁^f[^̐Ɏsꍇ
     */
    @Override
    public void importXML(Element element) throws DeploymentException{
        super.importXML(element);
        
        if(!element.getTagName().equals(INVOKE_TAG_NAME)){
            throw new DeploymentException(
                "Tag must be " + INVOKE_TAG_NAME + " : "
                 + element.getTagName()
            );
            
        }
        name = getUniqueAttribute(element, NAME_ATTRIBUTE_NAME);
        final Iterator<Element> argElements = getChildrenByTagName(
            element,
            ArgumentMetaData.ARGUMENT_TAG_NAME
        );
        while(argElements.hasNext()){
            final ArgumentMetaData argData = new ArgumentMetaData(
                this,
                (ObjectMetaData)getParentObjectMetaData()
            );
            argData.importXML((Element)argElements.next());
            addArgument(argData);
        }
        final String callStateVal = getOptionalAttribute(
            element,
            CALL_STATE_ATTRIBUTE_NAME
        );
        if(callStateVal != null){
            setCallState(callStateVal);
            if(getCallStateValue() == Service.State.UNKNOWN){
                throw new DeploymentException("Illegal call state. methodName=" + name + ", callState=" + callStateVal);
            }
        }
        
        final Element targetElement
             = getOptionalChild(element, TARGET_TAG_NAME);
        if(targetElement != null){
            final ObjectMetaData parentObjData = getParentObjectMetaData();
            
            Element targetObjElement = getOptionalChild(
                targetElement,
                ObjectMetaData.OBJECT_TAG_NAME
            );
            if(targetObjElement != null){
                ObjectMetaData objData = new ObjectMetaData(
                    parentObjData == null ? null : parentObjData.getServiceLoader(),
                    this,
                    parentObjData == null ? null : parentObjData.getManagerName()
                );
                objData.importXML(targetObjElement);
                target = objData;
                return;
            }
            
            targetObjElement = getOptionalChild(
                targetElement,
                ServiceRefMetaData.SERIVCE_REF_TAG_NAME
            );
            if(targetObjElement != null){
                ServiceRefMetaData serviceRefData = new ServiceRefMetaData(
                    this,
                    parentObjData == null ? null : parentObjData.getManagerName()
                );
                serviceRefData.importXML(targetObjElement);
                target = serviceRefData;
                return;
            }
            
            targetObjElement = getOptionalChild(
                targetElement,
                StaticFieldRefMetaData.STATIC_FIELD_REF_TAG_NAME
            );
            if(targetObjElement != null){
                StaticFieldRefMetaData staticFieldData
                     = new StaticFieldRefMetaData(this);
                staticFieldData.importXML(targetObjElement);
                target = staticFieldData;
                return;
            }
            
            targetObjElement = getOptionalChild(
                targetElement,
                StaticInvokeMetaData.STATIC_INVOKE_TAG_NAME
            );
            if(targetObjElement != null){
                StaticInvokeMetaData staticInvokeData
                     = new StaticInvokeMetaData(this);
                staticInvokeData.importXML(targetObjElement);
                target = staticInvokeData;
                return;
            }
            
            targetObjElement = getOptionalChild(
                targetElement,
                InvokeMetaData.INVOKE_TAG_NAME
            );
            if(targetObjElement != null){
                InvokeMetaData invokeData
                     = new InvokeMetaData(this);
                invokeData.importXML(targetObjElement);
                if(invokeData.getTarget() == null){
                    throw new DeploymentException(
                        "Target is null." + invokeData
                    );
                }
                target = invokeData;
                return;
            }
        }
    }
    
    @Override
    public StringBuilder toXML(StringBuilder buf){
        appendComment(buf);
        buf.append('<').append(INVOKE_TAG_NAME);
        if(name != null){
            buf.append(' ').append(NAME_ATTRIBUTE_NAME)
                .append("=\"").append(name).append("\"");
        }
        if(getParent() != null && getParent() instanceof ServiceMetaData && callState != null){
            buf.append(' ').append(CALL_STATE_ATTRIBUTE_NAME)
                .append("=\"").append(callState).append("\"");
        }
        if(target == null && arguments.size() == 0){
            buf.append("/>");
        }else{
            buf.append('>');
            if(target != null){
                buf.append(LINE_SEPARATOR);
                StringBuilder subBuf = new StringBuilder();
                subBuf.append('<').append(TARGET_TAG_NAME).append('>');
                subBuf.append(LINE_SEPARATOR);
                subBuf.append(
                    addIndent(target.toXML(new StringBuilder()))
                );
                subBuf.append(LINE_SEPARATOR);
                subBuf.append("</").append(TARGET_TAG_NAME).append('>');
                buf.append(addIndent(subBuf));
            }
            if(arguments.size() != 0){
                buf.append(LINE_SEPARATOR);
                for(int i = 0, imax = arguments.size(); i < imax; i++){
                    buf.append(
                        addIndent(((MetaData)arguments.get(i)).toXML(new StringBuilder()))
                    );
                    if(i != imax - 1){
                        buf.append(LINE_SEPARATOR);
                    }
                }
            }
            buf.append(LINE_SEPARATOR);
            buf.append("</").append(INVOKE_TAG_NAME).append('>');
        }
        return buf;
    }
    
    protected ObjectMetaData getParentObjectMetaData(){
        MetaData parent = getParent();
        while(parent != null && !(parent instanceof ObjectMetaData)){
            parent = parent.getParent();
        }
        return (ObjectMetaData)parent;
    }
    
    /**
     * ̃CX^X̕\擾B<p>
     *
     * @return \
     */
    @Override
    public String toString(){
        final StringBuilder buf = new StringBuilder();
        buf.append(super.toString());
        buf.append('{');
        buf.append(NAME_ATTRIBUTE_NAME);
        buf.append('=');
        buf.append(getName());
        if(arguments.size() != 0){
            buf.append(',');
            final Iterator<ArgumentMetaData> args = arguments.iterator();
            while(args.hasNext()){
                buf.append(args.next());
                if(args.hasNext()){
                    buf.append(',');
                }
            }
        }
        buf.append('}');
        return buf.toString();
    }
}
