/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.daemon;

import jp.ossc.nimbus.util.SynchronizeMonitor;
import jp.ossc.nimbus.util.WaitSynchronizeMonitor;

/**
 * f[XbhB<p>
 * f[XbḧSȐ߂̂łB<br>
 *
 * @author H.Nakano
 */
public class Daemon implements Runnable, DaemonControl{
    
    //## NXo[ϐ錾 ##
    
    /**
     * f[ғtOB<p>
     */
    protected volatile boolean isRunning;
    
    /**
     * ubLOԔtOB<p>
     */
    protected volatile boolean isBlocking;
    
    /**
     * TXyhԔtOB<p>
     */
    protected volatile boolean isSusupend;
    protected SynchronizeMonitor susupendMonitor = new WaitSynchronizeMonitor();
    
    /**
     * f[XbhIuWFNgB<p>
     */
    protected transient Thread daemonThread;
    
    /**
     * f[XbhB<p>
     */
    protected String threadName;
    
    /**
     * f[ݒtOB<p>
     * ftHǵAtrueB
     */
    protected boolean isDaemon = true;
    
    /**
     * f[iuB<p>
     */
    protected DaemonRunnable<Object> runnable;
    
    /**
     * Kx[WtOB<p>
     */
    protected boolean isGarbaging;
    
    /**
     * tOB<p>
     */
    protected boolean isConsuming;
    
    /**
     * tOB<p>
     */
    protected boolean isProviding;
    
    /**
     * D揇ʁB<p>
     */
    protected int priority = -1;
    
    protected long suspendCheckInterval = 500l;
    
    /**
     * CX^X𐶐B<p>
     *
     * @param run f[sDaemonRunnable
     */
    @SuppressWarnings("unchecked")
    public Daemon(DaemonRunnable<?> run){
        runnable = (DaemonRunnable<Object>)run;
    }
    
    /**
     * {@link DaemonRunnable}擾B<p>
     * 
     * @return DaemonRunnable
     */
    public DaemonRunnable<?> getDaemonRunnable(){
        return runnable;
    }
    
    /**
     * f[Xbh擾B<p>
     *
     * @return f[Xbh
     */
    public Thread getDaemonThread(){
        return daemonThread;
    }
    
    /**
     * f[Xbh̖Oݒ肷B<p>
     * 
     * @param name f[Xbh̖O
     */
    public void setName(String name){
        threadName = name;
        if(daemonThread != null){
            daemonThread.setName(name);
        }
    }
    
    /**
     * f[Xbh̖O擾B<p>
     * 
     * @return f[Xbh̖O
     */
    public String getName(){
        return threadName;
    }
    
    /**
     * f[Xbh̗D揇ʂݒ肷B<p>
     * 
     * @param newPriority f[Xbh̗D揇
     */
    public void setPriority(int newPriority){
        priority = newPriority;
        if(daemonThread != null){
            daemonThread.setPriority(newPriority);
        }
    }
    
    /**
     * f[Xbh̗D揇ʂݒ肷B<p>
     * 
     * @return f[Xbh̗D揇
     */
    public int getPriority(){
        return daemonThread == null ? priority : daemonThread.getPriority();
    }
    
    /**
     * ꎞ~畜Aׂ`FbNԊu[ms]ݒ肷B<p>
     * ftHǵA500[ms]B<br>
     *
     * @param interval `FbNԊu[ms]
     */
    public void setSuspendCheckInterval(long interval){
        suspendCheckInterval = interval;
    }
    
    /**
     * ꎞ~畜Aׂ`FbNԊu[ms]擾B<p>
     *
     * @return `FbNԊu[ms]
     */
    public long getSuspendCheckInterval(){
        return suspendCheckInterval;
    }
    
    /**
     * ғԂ𔻒肷B<p>
     * 
     * @return truȅꍇAғ
     */
    @Override
    public boolean isRunning(){
        return this.isRunning;
    }
    
    /**
     * ғԂݒ肷B<p>
     * 
     * @param runFlg ғɐݒ肵ꍇtrue
     */
    @Override
    public void setRunning(boolean runFlg){
        this.isRunning = runFlg;
    }
    
    /**
     * ubLOԂ𔻒肷B<p>
     *
     * @return truȅꍇAubN
     */
    @Override
    public boolean isBlocking(){
        return this.isBlocking;
    }
    
    /**
     * ubLOԂݒ肷B<p>
     *
     * @param blockFlg ubNɐݒ肵ꍇtrue
     */
    @Override
    public void setBlocking(boolean blockFlg){
        this.isBlocking = blockFlg;
    }
    
    /**
     * f[tOݒ肷B<p>
     * ftHgł́AtrueB
     *
     * @param isDaemon f[Xbhɂꍇtrue
     */
    public void setDaemon(boolean isDaemon){
        this.isDaemon = isDaemon;
    }
    
    /**
     * f[Xbhǂ肷B<p>
     *
     * @return truȅꍇAf[Xbh
     */
    public boolean isDaemon(){
        return isDaemon ;
    }
    
    /**
     * ǂ𔻒肷B<p>
     *
     * @return ̏ꍇtrue
     */
    public boolean isProviding(){
        return isProviding;
    }
    
    /**
     * ǂ𔻒肷B<p>
     *
     * @return ̏ꍇtrue
     */
    public boolean isConsuming(){
        return isConsuming;
    }
    
    /**
     * ꎞ~ǂ𔻒肷B<p>
     *
     * @return ꎞ~̏ꍇtrue
     */
    public boolean isSusupend(){
        return isSusupend;
    }
    
    /**
     * XbhJnB<p>
     */
    public synchronized void start(){
        // łɎsȂ烊^[
        if(isRunning()){
            return;
        }else if(!runnable.onStart()){
            return;
        }
        // VXbh쐬
        if(getName() == null || getName().length() == 0){
            daemonThread = new Thread(this);
        }else{
            daemonThread = new Thread(this, getName());
        }
        daemonThread.setDaemon(isDaemon());
        if(priority > 0){
            daemonThread.setPriority(priority);
        }
        
        // stOݒ
        setRunning(true);
        setBlocking(true);
        if(isSusupend){
            susupendMonitor.initMonitor(daemonThread);
        }
        
        daemonThread.start();
    }
    
    /**
     * Xbh~B<p>
     * Xbh~܂ŁA60bҋ@B
     */
    public synchronized void stop(){
        stop(60000);
    }
    
    /**
     * Xbh~B<p>
     * Xbh~܂ŁAw肳ꂽԂҋ@B
     *
     * @param millis ҋ@[ms]
     */
    public synchronized void stop(long millis){
        if(daemonThread == null){
            // f[͒~
            return;
        }else if(!runnable.onStop()){
            return;
        }
        
        setRunning(false);
        if(isBlocking() && daemonThread != null && daemonThread.isAlive()){
            isSusupend = false;
        }
        if(daemonThread != null){
            daemonThread.interrupt();
            
            if(isConsuming){
                if(!daemonThread.isInterrupted()){
                    daemonThread.interrupt();
                }
            }
        }
        if(millis >= 0){
            stopWait(millis);
        }
    }
    
    /**
     * Xbh~܂ő҂B<p>
     */
    public synchronized void stopWait(){
        stopWait(0);
    }
    
    /**
     * Xbh~܂ő҂B<p>
     */
    public synchronized void stopWait(long millis){
        long startTime = System.currentTimeMillis();
        try{
            if(daemonThread != null){
                daemonThread.join(millis);
            }
        }catch(InterruptedException e){
            Thread.interrupted();
            long processTime = System.currentTimeMillis() - startTime;
            if(millis > processTime){
                stopWait(millis - processTime);
            }
        }
        daemonThread = null;
    }
    
    /**
     * Xbhɒ~߂oB<p>
     */
    public synchronized void stopNoWait(){
        stop(-1);
    }
    
    /**
     * Xbhꎞ~B<p>
     */
    @Override
    public synchronized void suspend(){
        if(isSusupend){
            // f[͒~
            return;
        }else if(!runnable.onSuspend()){
            return;
        }
        isSusupend = true;
        if(daemonThread != null){
            susupendMonitor.initMonitor(daemonThread);
        }
    }
    
    /**
     * XbhĊJB<p>
     */
    @Override
    public synchronized void resume(){
        if(!isSusupend){
            // f[͒~
            return;
        }else if(!runnable.onResume()){
            return;
        }
        isSusupend = false;
        susupendMonitor.notifyMonitor();
    }
    
    /**
     * f[XbhsB<p>
     */
    @Override
    public void run(){
        boolean breakFlg = false;
        Object waitObj = null;
        try{
            //[v͈ȉ̂Q̕ϐ𐧌䂷邱ƁB
            while(isRunning()){
                setBlocking(true);
                // 炩̃ANV҂ꍇInterruptedException
                // Lb`邱
                while(isSusupend){
                    try{
                        susupendMonitor.waitMonitor(suspendCheckInterval);
                    }catch(InterruptedException e1){
                        Thread.interrupted();
                        breakFlg = true;
                        break;
                    }
                }
                if(breakFlg){
                    breakFlg = false;
                    continue;
                }
                isProviding = true;
                try{
                    waitObj = runnable.provide(this);
                }catch(InterruptedException e){
                    if(!breakFlg && isRunning()){
                        e.printStackTrace();
                    }else{
                        break;
                    }
                }catch(Throwable e){
                    if(!breakFlg && isRunning()){
                        e.printStackTrace();
                    }
                    Thread.interrupted();
                    waitObj = null;
                }
                isProviding = false;
                while(this.isSusupend){
                    try{
                        susupendMonitor.waitMonitor(suspendCheckInterval);
                    }catch(InterruptedException e2){
                        Thread.interrupted();
                        breakFlg= true;
                        break;
                    }
                }
                setBlocking(false);
                if(breakFlg){
                    breakFlg = false;
                    continue;
                }
                // 
                isConsuming = true;
                try{
                    runnable.consume(waitObj, this);
                }catch(InterruptedException e){
                    if(!breakFlg && isRunning()){
                        e.printStackTrace();
                    }
                }catch(Throwable e){
                    if(!breakFlg && isRunning()){
                        e.printStackTrace();
                    }
                }
                isConsuming = false;
            }
        }finally{
            // I̓L[̎co
            setRunning(false);
            isGarbaging = true;
            try{
                runnable.garbage();
            }catch(Throwable e){
                e.printStackTrace();
            }
            isGarbaging = false;
        }
    }
}
