/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.io;

import java.io.*;

/**
 * gqw̃t@CtB^B<p>
 *
 * @author H.Nakano
 */
public class ExtentionFileFilter implements FilenameFilter, Serializable{
    
    private static final long serialVersionUID = 5687776723127309667L;
    
    /**
     * t@C̊gqB<p>
     */
    protected String extention;
    
    /**
     * gq̑啶Eʂ邩ǂ̃tOB<p>
     * ftHǵAtrueŁA啶EʂȂB<br>
     */
    protected boolean isIgnoreCase = true;
    
    private String upperExtention;
    
    /**
     * gqw肵ȂtB^̃CX^X𐶐B<p>
     */
    public ExtentionFileFilter(){
        this(null, true);
    }
    
    /**
     * w肵gq̃t@CtB^̃CX^X𐶐B<p>
     *
     * @param ext gq
     */
    public ExtentionFileFilter(String ext){
        this(ext, true);
    }
    
    /**
     * w肵gq̃t@CtB^̃CX^X𐶐B<p>
     *
     * @param ext gq
     * @param isIgnoreCase 啶EʂȂꍇtrue
     */
    public ExtentionFileFilter(String ext, boolean isIgnoreCase){
        setExtention(ext);
        setIgnoreCase(isIgnoreCase);
    }
    
    /**
     * t@C̊gqݒ肷B<p>
     * w肳ꂽgqA"."n܂Ȃꍇ́AIɕtB܂Anull󕶎w肵ꍇ́AtB^OȂB<br>
     * 
     * @param ext t@C̊gq
     */
    public void setExtention(String ext){
        if(ext == null || ext.length() == 0){
            extention = null;
        }else if(ext.charAt(0) == '.'){
            extention = ext;
            upperExtention = extention.toUpperCase();
        }else{
            extention = '.' + ext;
            upperExtention = extention.toUpperCase();
        }
    }
    
    /**
     * t@C̊gq擾B<p>
     * 
     * @return t@C̊gq
     */
    public String getExtention(){
        return extention;
    }
    
    /**
     * gq̑啶E𖳎邩ǂݒ肷B<p>
     * ftHǵAtrueB
     *
     * @param isIgnoreCase 啶EʂȂꍇtrue
     */
    public void setIgnoreCase(boolean isIgnoreCase){
        this.isIgnoreCase = isIgnoreCase;
    }
    
    /**
     * gq̑啶E𖳎邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇA啶EʂȂ
     */
    public boolean isIgnoreCase(){
        return isIgnoreCase;
    }
    
    /**
     * w肳ꂽgq̃t@Cǂ肷B<p>
     * 
     * @param dir fBNg
     * @param fileName t@C
     * @return w肳ꂽgq̃t@C̏ꍇtrue
     */
    @Override
    public boolean accept(File dir, String fileName){
        if(extention == null){
            return true;
        }else if(isIgnoreCase){
            String tmp = fileName.toUpperCase();
            return tmp.endsWith(upperExtention);
        }else{
            return fileName.endsWith(extention);
        }
    }
}
