/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.io;

import java.io.*;
import java.math.*;
import java.util.*;
import java.nio.*;
import java.lang.reflect.*;

import jp.ossc.nimbus.util.converter.PaddingStringConverter;

/**
 * FLViFixed Length Valuej`ReaderNXB<p>
 * <pre>
 * import java.io.*;
 * import jp.ossc.nimbus.io.FLVReader;
 *
 * FileInputStream fis = new FileInputStream("sample.csv");
 * InputStreamReader isr = new InputStreamReader(fis, "UTF-8");
 * FLVReader reader = new FLVReader(isr);
 * reader.setFieldLength(new int[]{5,10});
 * reader.setEncoding("UTF-8");
 * try{
 *     String[] flv = null;
 *     while((flv = reader.readFLVLine()) != null){
 *           :
 *     }
 * }finally{
 *     reader.close();
 * }
 * </pre>
 * 
 * @author M.Takata
 */
public class FLVReader extends LineNumberReader{
    
    /**
     * ftHg̉sB<p>
     */
    public static final String LINE_SEPARATOR
         = System.getProperty("line.separator");
    
    protected String encoding;
    protected int[] fieldLength;
    protected PaddingStringConverter[] converters;
    
    protected boolean isIgnoreEmptyLine;
    protected String commentPrefix;
    
    protected FLVIterator iterator;
    
    protected ReaderWrapper readerWrapper;
    
    /**
     * ftHg̓ǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     */
    public FLVReader(){
        this(new ReaderWrapper());
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param fieldLen tB[h̔z
     */
    public FLVReader(int... fieldLen){
        this((String)null, fieldLen);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     */
    public FLVReader(String encoding, int... fieldLen){
        this(new ReaderWrapper(), encoding, fieldLen);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     * @param convs tB[h̃pfBORo[^z
     */
    public FLVReader(String encoding, int[] fieldLen, PaddingStringConverter[] convs){
        this(new ReaderWrapper(), encoding, fieldLen, convs);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     */
    public FLVReader(Reader reader){
        this(reader, (int[])null);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param fieldLen tB[h̔z
     */
    public FLVReader(Reader reader, int... fieldLen){
        this(reader, null, fieldLen);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     */
    public FLVReader(Reader reader, String encoding, int... fieldLen){
        this(reader, encoding, fieldLen, (PaddingStringConverter[])null);
    }
    
    /**
     * ftHg̓ǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     * @param convs tB[h̃pfBORo[^z
     */
    public FLVReader(Reader reader, String encoding, int[] fieldLen, PaddingStringConverter[] convs){
        super(reader instanceof ReaderWrapper ? reader : new ReaderWrapper(reader));
        readerWrapper = (ReaderWrapper)lock;
        fieldLength = fieldLen;
        converters = convs;
        this.encoding = encoding;
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param size ǂݍ݃obt@TCY
     */
    public FLVReader(int size){
        this(size, (int[])null);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param size ǂݍ݃obt@TCY
     * @param fieldLen tB[h̔z
     */
    public FLVReader(int size, int... fieldLen){
        this(size, null, fieldLen);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param size ǂݍ݃obt@TCY
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     */
    public FLVReader(int size, String encoding, int... fieldLen){
        this(size, encoding, fieldLen, (PaddingStringConverter[])null);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYڑ̃CX^X𐶐B<p>
     *
     * @param size ǂݍ݃obt@TCY
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     * @param convs tB[h̃pfBORo[^z
     */
    public FLVReader(int size, String encoding, int[] fieldLen, PaddingStringConverter[] convs){
        this(new ReaderWrapper(), size, encoding, fieldLen, convs);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param size ǂݍ݃obt@TCY
     */
    public FLVReader(Reader reader, int size){
        this(reader, size, (int[])null);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param size ǂݍ݃obt@TCY
     * @param fieldLen tB[h̔z
     */
    public FLVReader(Reader reader, int size, int... fieldLen){
        this(reader, size, null, fieldLen);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param size ǂݍ݃obt@TCY
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     */
    public FLVReader(Reader reader, int size, String encoding, int[] fieldLen){
        this(reader, size, encoding, fieldLen, (PaddingStringConverter[])null);
    }
    
    /**
     * w肳ꂽǂݍ݃obt@TCYCX^X𐶐B<p>
     *
     * @param reader ǂݍ݌Reader
     * @param size ǂݍ݃obt@TCY
     * @param encoding GR[fBO
     * @param fieldLen tB[h̔z
     * @param convs tB[h̃pfBORo[^z
     */
    public FLVReader(Reader reader, int size, String encoding, int[] fieldLen, PaddingStringConverter[] convs){
        super(reader instanceof ReaderWrapper ? reader : new ReaderWrapper(reader), size);
        readerWrapper = (ReaderWrapper)lock;
        fieldLength = fieldLen;
        converters = convs;
        this.encoding = encoding;
    }
    
    /**
     * etB[h̃oCgݒ肷B<p>
     *
     * @param length tB[h̔z
     */
    public void setFieldLength(int... length){
        fieldLength = length;
    }
    
    /**
     * etB[h̃oCg擾B<p>
     *
     * @return tB[h̔z
     */
    public int[] getFieldLength(){
        return fieldLength;
    }
    
    /**
     * etB[h̃pfBỎsRo[^ݒ肷B<p>
     *
     * @param convs pfBỎsRo[^̔z
     */
    public void setFieldPaddingStringConverter(PaddingStringConverter... convs){
        converters = convs;
    }
    
    /**
     * etB[h̃pfBỎsRo[^擾B<p>
     *
     * @return pfBỎsRo[^̔z
     */
    public PaddingStringConverter[] getFieldPaddingStringConverter(){
        return converters;
    }
    
    /**
     * GR[fBOݒ肷B<p>
     *
     * @param enc GR[fBO
     */
    public void setEncoding(String enc){
        encoding = enc;
    }
    
    /**
     * GR[fBO擾B<p>
     *
     * @return GR[fBO
     */
    public String getEncoding(){
        return encoding;
    }
    
    /**
     * Readerݒ肷B<p>
     *
     * @param reader Reader
     * @exception IOException Readerݒ肳Ăꍇ
     */
    public void setReader(Reader reader) throws IOException{
        readerWrapper.setReader(reader);
    }
    
    /**
     * s𖳎邩ǂݒ肷B<p>
     * s𖳎悤ɐݒ肵ꍇAs͍sƂĂJEgȂB<br>
     * ftHǵAfalseŖȂB<br>
     *
     * @param isIgnore s𖳎ꍇtrue
     */
    public void setIgnoreEmptyLine(boolean isIgnore){
        isIgnoreEmptyLine = isIgnore;
    }
    
    /**
     * s𖳎邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAs𖳎
     */
    public boolean isIgnoreEmptyLine(){
         return isIgnoreEmptyLine;
    }
    
    /**
     * Rgs̑Ouݒ肷B<p>
     *
     * @param value Rgs̑Ou
     */
    public void setCommentPrefix(String value){
        commentPrefix = value;
    }
    
    /**
     * Rgs̑Ou擾B<p>
     *
     * @return Rgs̑Ou
     */
    public String getCommentPrefix(){
        return commentPrefix;
    }
    
    /**
     * w肳ꂽsXLbvB<p>
     *
     * @param line XLbvs
     * @return XLbvꂽs
     * @exception IOException o̓G[ꍇ
     */
    public long skipLine(long line) throws IOException{
        int result = 0;
        for(result = 0; result < line; result++){
            if(super.readLine() == null){
                break;
            }
        }
        return result;
    }
    
    /**
     * w肳ꂽFLVsXLbvB<p>
     * {@link #isIgnoreEmptyLine()}truȅꍇ́As̓XLbvs̃JEg珜B<br>
     *
     * @param line XLbvs
     * @return XLbvꂽs
     * @exception IOException o̓G[ꍇ
     */
    public long skipFLVLine(long line) throws IOException{
        List<String> flv = null;
        int result = 0;
        for(result = 0; result < line; result++){
            flv = readFLVLineList(flv);
            if(flv == null){
                break;
            }
        }
        return result;
    }
    
    /**
     * FLVs1sǂݍށB<p>
     *
     * @return FLVvf̕z
     * @exception IOException o̓G[ꍇ
     */
    public String[] readFLVLine() throws IOException{
        final List<String> flv = readFLVLineList();
        return flv == null ? null
             : flv.toArray(new String[flv.size()]);
    }
    
    /**
     * FLVs1sǂݍށB<p>
     *
     * @return FLVvf̕񃊃Xg
     * @exception IOException o̓G[ꍇ
     */
    public List<String> readFLVLineList() throws IOException{
        return readFLVLineList(null);
    }
    
    /**
     * FLVs1sǂݍށB<p>
     * FLVvf̕i[郊Xgėp邽߂̃\bhłB<br>
     *
     * @param flv FLVvf̕i[郊Xg
     * @return FLVvf̕񃊃Xg
     * @exception IOException o̓G[ꍇ
     */
    public List<String> readFLVLineList(List<String> flv) throws IOException{
        String line = null;
        do{
            line = readLine();
            if(line == null){
                if(flv != null){
                    flv.clear();
                }
                return null;
            }
            if((isIgnoreEmptyLine && line.length() == 0)
                    || (commentPrefix != null && line.startsWith(commentPrefix))
            ){
                line = null;
                setLineNumber(getLineNumber() - 1);
            }
        }while(line == null);
        if(flv == null){
            flv = new ArrayList<String>();
        }else{
            flv.clear();
        }
        if(line.length() == 0){
            return flv;
        }
        byte[] bytes = null;
        if(encoding == null){
            bytes = line.getBytes();
        }else{
            bytes = line.getBytes(encoding);
        }
        int offset = 0;
        for(int i = 0; i < fieldLength.length; i++){
            if(bytes.length < offset + fieldLength[i]){
                throw new EOFException();
            }
            String element = null;
            if(encoding == null){
                element = new String(bytes, offset, fieldLength[i]);
            }else{
                element = new String(bytes, offset, fieldLength[i], encoding);
            }
            if(converters != null && converters.length != 0 && converters[i] != null){
                element = converters[i].parse(element);
            }
            flv.add(element);
            offset += fieldLength[i];
        }
        return flv;
    }
    
    public String readLine() throws IOException{
        if(readerWrapper.getReader() instanceof BufferedReader){
            return ((BufferedReader)readerWrapper.getReader()).readLine();
        }else{
            return super.readLine();
        }
    }
    
    /**
     * {@link FLVReader.FLVElements}̌JԂ擾B<p>
     *
     * @return FLVElementšJԂ
     */
    public FLVIterator iterator(){
        if(iterator == null){
            iterator = new FLVIterator();
        }
        return iterator;
    }
    
    /**
     * {@link FLVReader.FLVElements}̌JԂB<p>
     *
     * @author M.Takata
     */
    public class FLVIterator{
        private boolean hasNext = false;
        private FLVElements elements = new FLVElements();
        
        private FLVIterator(){}
        
        /**
         * FLVvf邩ǂ𔻒肷B<p>
         *
         * @return FLVvfꍇtrue
         * @exception IOException ǂݍ݂Ɏsꍇ
         */
        public boolean hasNext() throws IOException{
            if(hasNext){
                return hasNext;
            }
            List<String> result = readFLVLineList(elements);
            hasNext = result != null;
            return hasNext;
        }
        
        /**
         * FLVvf擾B<p>
         *
         * @return FLVvfBFLVvfȂꍇnull
         * @exception IOException ǂݍ݂Ɏsꍇ
         * @see #nextElements()
         */
        public Object next() throws IOException{
            return nextElements();
        }
        
        /**
         * FLVvf擾B<p>
         * Ŏ擾{@link FLVReader.FLVElements}́AėpB<br>
         *
         * @return FLVvfBFLVvfȂꍇnull
         * @exception IOException ǂݍ݂Ɏsꍇ
         */
        public FLVElements nextElements() throws IOException{
            if(!hasNext){
                if(!hasNext()){
                    return null;
                }
            }
            hasNext = false;
            return elements;
        }
    }
    
    /**
     * ڑ̕𐶐B<p>
     *
     * @return ڑ̕
     */
    public FLVReader cloneReader(){
        return cloneReader(new FLVReader());
    }
    
    /**
     * ڑ̕𐶐B<p>
     *
     * @param clone ڑ̃CX^X
     * @return ڑ̕
     */
    protected FLVReader cloneReader(FLVReader clone){
        clone.encoding = encoding;
        clone.fieldLength = fieldLength;
        clone.isIgnoreEmptyLine = isIgnoreEmptyLine;
        clone.commentPrefix = commentPrefix;
        if(converters != null && converters.length != 0){
            clone.converters = new PaddingStringConverter[converters.length];
            System.arraycopy(converters, 0, clone.converters, 0, converters.length);
        }
        return clone;
    }
    
    /**
     * FLV`f[^1s\FLVvfB<p>
     * 
     * @author M.Takata
     */
    public class FLVElements extends ArrayList<String>{
        
        private static final long serialVersionUID = 1308350474228564200L;
        
        private boolean wasNull;
        
        private FLVElements(){}
        
        /**
         * FLVvfNAB<p>
         */
        public void clear(){
            wasNull = false;
            super.clear();
        }
        
        /**
         * 擾lnullǂ𔻒肷B<p>
         * {@link #getInt(int)}Ȃǂ́AlngetterŒl擾ꍇAlnull󕶎ꍇɁA0ԂB̎Al0̂null܂͋󕶎̂𔻒f̂ɎgpB<br>
         *
         * @return 擾lnullꍇtrue
         */
        public boolean wasNull(){
            return wasNull;
        }
        
        /**
         * w肳ꂽCfbNX̗vf擾B<p>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vf
         */
        public String get(int index){
            String obj = super.get(index);
            wasNull = obj == null;
            return obj;
        }
        
        /**
         * w肳ꂽCfbNX̗vf擾B<p>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vf
         */
        public String getString(int index){
            String str = (String)get(index);
            wasNull = str == null;
            return str;
        }
        
        /**
         * w肳ꂽCfbNX̗vfoCg擾B<p>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfoCg
         * @exception NumberFormatException vfoCgłȂꍇ
         */
        public byte getByte(int index) throws NumberFormatException{
            return getByte(index, 10);
        }
        
        /**
         * w肳ꂽCfbNX̗vfoCg擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @param radix 
         * @return w肳ꂽCfbNX̗vfoCg
         * @exception NumberFormatException vfoCgłȂꍇ
         */
        public byte getByte(int index, int radix) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return (byte)0;
            }
            return Byte.parseByte(str, radix);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public short getShort(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return (short)0;
            }
            return Short.parseShort(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vf擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         * ܂Aw肳ꂽvfA琬ꍇ́A1ڂԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vf
         */
        public char getChar(int index){
            final String str = getString(index);
            if(str == null || str.length() == 0){
                wasNull = true;
                return (char)0;
            }
            return str.charAt(0);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public int getInt(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return (int)0;
            }
            return Integer.parseInt(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public long getLong(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return 0l;
            }
            return Long.parseLong(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public float getFloat(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return 0.0f;
            }
            return Float.parseFloat(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́A0ԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public double getDouble(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return 0.0d;
            }
            return Double.parseDouble(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vftO擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́AfalseԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vftO
         */
        public boolean getBoolean(int index){
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return false;
            }
            return Boolean.valueOf(str).booleanValue();
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́AnullԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public BigInteger getBigInteger(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return null;
            }
            return new BigInteger(str);
        }
        
        /**
         * w肳ꂽCfbNX̗vfl擾B<p>
         * w肳ꂽvfnull܂͋󕶎̏ꍇ́AnullԂA{@link #wasNull()}trueԂB<br>
         *
         * @param index CfbNX
         * @return w肳ꂽCfbNX̗vfl
         * @exception NumberFormatException vflłȂꍇ
         */
        public BigDecimal getBigDecimal(int index) throws NumberFormatException{
            String str = getString(index);
            if(str != null && str.length() == 0){
                str = str.trim();
            }
            if(str == null || str.length() == 0){
                wasNull = true;
                return null;
            }
            return new BigDecimal(str);
        }
    }
    
    private static class ReaderWrapper extends Reader{
        
        private Reader realReader;
        private static Method READ_CHARBUFFER_METHOD = null;
        static{
            try{
                READ_CHARBUFFER_METHOD = Reader.class.getMethod(
                    "read",
                    new Class[]{CharBuffer.class}
                );
            }catch(NoSuchMethodException e){
            }
        }
        
        public ReaderWrapper(){
        }
        
        public ReaderWrapper(Reader reader){
            realReader = reader;
        }
        
        public Reader getReader(){
            return realReader;
        }
        
        public void setReader(Reader reader) throws IOException{
            if(realReader != null){
                throw new IOException("Reader is already commited.");
            }
            realReader = reader;
        }
        
        public int read(CharBuffer target) throws IOException{
            if(READ_CHARBUFFER_METHOD == null){
                throw new UnsupportedOperationException("No such method.");
            }
            if(realReader == null){
                return -1;
            }else{
                try{
                    return ((Integer)READ_CHARBUFFER_METHOD.invoke(realReader, new Object[]{target})).intValue();
                }catch(InvocationTargetException e){
                    Throwable th = e.getTargetException();
                    if(th instanceof IOException){
                        throw (IOException)th;
                    }else if(th instanceof RuntimeException){
                        throw (RuntimeException)th;
                    }else if(th instanceof Error){
                        throw (Error)th;
                    }else{
                        throw new UndeclaredThrowableException(th);
                    }
                }catch(IllegalAccessException e){
                    throw new UnsupportedOperationException(e.toString());
                }
            }
        }
        
        public int read() throws IOException{
            if(realReader == null){
                return -1;
            }else{
                return realReader.read();
            }
        }
        
        public int read(char[] cbuf) throws IOException{
            if(realReader == null){
                return -1;
            }else{
                return realReader.read(cbuf);
            }
        }
        
        public int read(char[] cbuf, int off, int len) throws IOException{
            if(realReader == null){
                return -1;
            }else{
                return realReader.read(cbuf, off, len);
            }
        }
        
        public long skip(long n) throws IOException{
            if(realReader == null){
                return 0;
            }else{
                return realReader.skip(n);
            }
        }
        
        public boolean ready() throws IOException{
            if(realReader == null){
                return false;
            }else{
                return realReader.ready();
            }
        }
        
        public boolean markSupported(){
            if(realReader == null){
                return false;
            }else{
                return realReader.markSupported();
            }
        }
        
        public void mark(int readAheadLimit) throws IOException{
            if(realReader == null){
                throw new IOException("Reader is null.");
            }else{
                realReader.mark(readAheadLimit);
            }
        }
        
        public void reset() throws IOException{
            if(realReader != null){
                realReader.reset();
            }
        }
        
        public void close() throws IOException{
            if(realReader != null){
                realReader.close();
            }
        }
    }
}
