/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop;

import jp.ossc.nimbus.core.*;

/**
 * ftHgXbhPʃC^[Zv^`F[B<p>
 * ݌ĂяoĂC^[Zv^̏XbhPʂɃCX^XϐɊi[̂ŁAXbhZ[tȃC^[Zv^`F[łB<br>
 *
 * @author M.Takata
 */
public class DefaultThreadLocalInterceptorChain
 extends DefaultInterceptorChain implements java.io.Serializable{
    
    private static final long serialVersionUID = 5302115451138234378L;
    
    /**
     * ݌ĂяȍXbhPʂɕێThreadLocalB<p>
     */
    protected transient ThreadLocal<InterceptorChainState> state = new ThreadLocal<InterceptorChainState>(){
        @Override
        protected synchronized InterceptorChainState initialValue(){
            return new InterceptorChainState();
        }
    };
    
    /**
     * ̃C^[Zv^`F[𐶐B<p>
     */
    public DefaultThreadLocalInterceptorChain(){
        super();
    }
    
    /**
     * w肳ꂽ{@link InterceptorChainList}{@link Invoker}̃C^[Zv^`F[𐶐B<p>
     *
     * @param list `F[C^[Zv^̃Xg
     * @param invoker {̌ĂяoĂяoInvoker
     */
    public DefaultThreadLocalInterceptorChain(
        InterceptorChainList list,
        Invoker invoker
    ){
        super(list, invoker);
    }
    
    /**
     * w肳ꂽ{@link InterceptorChainList}T[rX{@link Invoker}T[rX̃C^[Zv^`F[𐶐B<p>
     *
     * @param listServiceName `F[C^[Zv^̃XgInterceptorChainListT[rX̃T[rX
     * @param invokerServiceName {̌ĂяoĂяoInvokerT[rX̃T[rX
     */
    public DefaultThreadLocalInterceptorChain(
        ServiceName listServiceName,
        ServiceName invokerServiceName
    ){
        super(listServiceName, invokerServiceName);
    }
    
    // InterceptorChainJavaDoc
    @Override
    public int getCurrentInterceptorIndex(){
        InterceptorChainState chainState = (InterceptorChainState)state.get();
        return chainState.currentIndex;
    }
    
    /**
     * ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNXݒ肷B<p>
     *
     * @param index ݂̃C^[Zv^̂̃C^[Zv^`F[̃CfbNX
     */
    public void setCurrentInterceptorIndex(int index){
        InterceptorChainState chainState = (InterceptorChainState)state.get();
        chainState.currentIndex = index;
    }
    
    // InterceptorChainJavaDoc
    @Override
    public InterceptorChain cloneChain(){
        DefaultThreadLocalInterceptorChain clone
             = (DefaultThreadLocalInterceptorChain)super.cloneChain();
        clone.state = new ThreadLocal<InterceptorChainState>(){
            protected synchronized InterceptorChainState initialValue(){
                return new InterceptorChainState();
            }
        };
        InterceptorChainState chainState
             = (InterceptorChainState)clone.state.get();
        chainState.currentIndex = getCurrentInterceptorIndex();
        return clone;
    }
    
    /**
     * ݌ĂяõC^[Zv^̏i[NXB<p>
     * 
     * @author M.Takata
     */
    protected static class InterceptorChainState
     implements java.io.Serializable{
        
        private static final long serialVersionUID = -24647693558335555L;
        
        /**
         * {@link InterceptorChainList}́Ȁ݂{@link Interceptor}̃CfbNXB<p>
         * ĺA-1B
         */
        public int currentIndex = -1;
    }
}
