/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.*;
import jp.ossc.nimbus.daemon.*;
import jp.ossc.nimbus.service.queue.*;

/**
 * \bh񓯊ĂяoC^[Zv^B<p>
 * \bȟĂяoɑ΂鏈񓯊ɃC^[Zv^łB<br>
 * ̃C^[Zv^̔񓯊Ăяoɂ́A3ނ̔񓯊ĂяoB<br>
 * P߂́A߂lKvƂȂ񓯊ĂяoB̏ꍇ́A߂l͕KnullԂB<br>
 * ȉɁȀꍇ̔񓯊ĂяoC^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="MethodAsynchronousInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.MethodAsynchronousInterceptorService/"&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 * Q߂́ACӂ̎Ԃ񓯊Ăяỏ҂񓯊ĂяoBԓɉԂĂΖ߂l܂͗OԂAԓɉԂĂȂnullԂBAA{@link #setFailToWaitResponseTimeout(boolean) setFailToWaitResponseTimeout(true)}ɐݒ肷ƁA{@link AsynchronousTimeoutException}throwB<br>
 * ȉɁȀꍇ̔񓯊ĂяoC^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="MethodAsynchronousInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.MethodAsynchronousInterceptorService"&gt;
 *             &lt;attribute name="ResponseTimeout"&gt;1000&lt;/attribute&gt;
 *         &lt;/service&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 * R߂́A\bh̖߂lthrowꂽOCӂ̃^C~OŎ擾񓯊ĂяoB̏ꍇ́AX|Xi[{@link Queue}T[rX̃T[rX̑ɐݒ肵AQueueT[rX߂lthrowꂽOi[{@link AsynchronousResponse}擾łB<br>
 * ȉɁȀꍇ̔񓯊ĂяoC^[Zv^̃T[rX`B<br>
 * <pre>
 * &lt;?xml version="1.0" encoding="Shift_JIS"?&gt;
 * 
 * &lt;nimbus&gt;
 *     
 *     &lt;manager name="Sample"&gt;
 *         
 *         &lt;service name="MethodAsynchronousInterceptor"
 *                  code="jp.ossc.nimbus.service.aop.interceptor.MethodAsynchronousInterceptorService"&gt;
 *             &lt;attribute name="ResponseQueueServiceName"&gt;#ResponseQueue&lt;/attribute&gt;
 *             &lt;depends&gt;ResponseQueue&lt;/depends&gt;
 *         &lt;/service&gt;
 *         
 *         &lt;service name="ResponseQueue"
 *                  code="jp.ossc.nimbus.service.queue.DefaultQueueService"/&gt;
 *         
 *     &lt;/manager&gt;
 *     
 * &lt;/nimbus&gt;
 * </pre>
 *
 * @author M.Takata
 * @see Queue
 */
public class MethodAsynchronousInterceptorService extends ServiceBase
 implements Interceptor, MethodAsynchronousInterceptorServiceMBean{
    
    private static final long serialVersionUID = 556687756097723606L;
    
    private ServiceName requestQueueServiceName;
    private DefaultQueueService<InvocationInfo> defaultRequestQueue;
    private Queue<InvocationInfo> requestQueue;
    private ServiceName responseQueueServiceName;
    private Queue<AsynchronousResponse> responseQueue;
    private Daemon[] daemons;
    private Invoker[] invokers;
    private long responseTimeout = -1;
    private boolean isFailToWaitResponseTimeout = true;
    private boolean isReturnResponse = true;
    private int invokerThreadSize = 1;
    private boolean isInvokerThreadDaemon = true;
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setRequestQueueServiceName(ServiceName name){
        requestQueueServiceName = name;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public ServiceName getRequestQueueServiceName(){
        return requestQueueServiceName;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setResponseQueueServiceName(ServiceName name){
        responseQueueServiceName = name;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public ServiceName getResponseQueueServiceName(){
        return responseQueueServiceName;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setResponseTimeout(long timeout){
        responseTimeout = timeout;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public long getResponseTimeout(){
        return responseTimeout;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setFailToWaitResponseTimeout(boolean isThrow){
        isFailToWaitResponseTimeout = isThrow;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public boolean isFailToWaitResponseTimeout(){
        return isFailToWaitResponseTimeout;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setInvokerThreadSize(int size){
        invokerThreadSize = size;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public int getInvokerThreadSize(){
        return invokerThreadSize;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setInvokerThreadDaemon(boolean isDaemon){
        isInvokerThreadDaemon = isDaemon;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public boolean isInvokerThreadDaemon(){
        return isInvokerThreadDaemon;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public int getActiveInvokerThreadSize(){
        if(invokers == null){
            return 0;
        }
        int count = 0;
        for(int i = 0; i < invokers.length; i++){
            if(invokers[i].isActive){
                count++;
            }
        }
        return count;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public void setReturnResponse(boolean isReturn){
        isReturnResponse = isReturn;
    }
    
    // MethodAsynchronousInterceptorServiceMBeanJavaDoc
    public boolean isReturnResponse(){
        return isReturnResponse;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception QueueT[rX̎擾Ɏsꍇ
     */
    public void startService() throws Exception{
        if(getRequestQueueServiceName() == null){
            if(getRequestQueueService() == null) {
                if(getDefaultRequestQueueService() == null){
                    final DefaultQueueService<InvocationInfo> defaultQueue
                         = new DefaultQueueService<InvocationInfo>();
                    defaultQueue.create();
                    defaultQueue.start();
                    setDefaultRequestQueueService(defaultQueue);
                }else{
                    getDefaultRequestQueueService().start();
                }
                setRequestQueueService(getDefaultRequestQueueService());
            }
        }else{
            setRequestQueueService(ServiceManagerFactory
                .<Queue<InvocationInfo>>getServiceObject(requestQueueServiceName)
            );
        }
        
        // L[tJn
        getRequestQueueService().accept();
        
        // f[N
        if(invokerThreadSize < 0){
            throw new IllegalArgumentException("invokerThreadSize < 0.");
        }
        invokers = new Invoker[invokerThreadSize];
        daemons = new Daemon[invokerThreadSize];
        for(int i = 0; i < invokerThreadSize; i++){
            invokers[i] = new Invoker();
            daemons[i] = new Daemon(invokers[i]);
            daemons[i].setName("Nimbus AsynchInvokerDaemon " + getServiceNameObject());
            daemons[i].setDaemon(isInvokerThreadDaemon);
            daemons[i].start();
        }
    }
    
    /**
     * T[rX̒~sB<p>
     *
     * @exception Exception T[rX̒~Ɏsꍇ
     */
    public void stopService() throws Exception{
        
        // f[~
        for(int i = 0; i < daemons.length; i++){
            daemons[i].stop();
            daemons[i] = null;
            invokers[i] = null;
        }
        
        // L[t~
        getRequestQueueService().release();
        
        daemons = null;
        invokers = null;
        
        if(getRequestQueueService() == getDefaultRequestQueueService()){
            getDefaultRequestQueueService().stop();
        }
    }
    
    /**
     * T[rX̔jsB<p>
     *
     * @exception Exception T[rX̔jɎsꍇ
     */
    public void destroyService(){
        
        if(getRequestQueueService() == getDefaultRequestQueueService()
            && getDefaultRequestQueueService() != null){
            getDefaultRequestQueueService().destroy();
            setDefaultRequestQueueService(null);
        }
    }
    
    /**
     * 񓯊ĂяoāAnullԂB<p>
     * {̃\bhĂяo̖߂́A{@link #setResponseQueueServiceName(ServiceName)}{@link Queue}T[rXݒ肳Ă΁AQueueɁA{@link AsynchronousResponse}ƂăL[Ă̂ŁA擾łB<br>
     * T[rXJnĂȂꍇ́A񓯊Ăяos킸Ɏ̃C^[Zv^ĂяoB<br>
     * 
     *
     * @param context ĂяõReLXg
     * @param chain ̃C^[Zv^Ăяo߂̃`F[
     * @return nullԂ
     * @exception Throwable ĂяoŗOꍇA܂͂̃C^[Zv^ŔCӂ̗OꍇBAA{Ăяo鏈throwȂRuntimeExceptionȊO̗OthrowĂAĂяoɂ͓`dȂB
     */
    public Object invoke(
        InvocationContext context,
        InterceptorChain chain
    ) throws Throwable{
        if(getState() == State.STARTED){
            InterceptorChain ch = chain;
            if(chain instanceof DefaultThreadLocalInterceptorChain){
                DefaultInterceptorChain tmp = new DefaultInterceptorChain(
                    chain.getInterceptorChainList(),
                    chain.getInvoker()
                );
                tmp.setCurrentInterceptorIndex(
                    chain.getCurrentInterceptorIndex()
                );
                ch = tmp;
            }
            
            final Queue<AsynchronousResponse> resQueue = getResponseQueue();
            final InvocationInfo invokeInfo = new InvocationInfo(
                (MethodInvocationContext)context,
                ch.cloneChain(),
                resQueue
            );
            getRequestQueueService().push(invokeInfo);
            
            if(resQueue != null && isReturnResponse){
                AsynchronousResponse response = null;
                if(responseTimeout > 0){
                    response = (AsynchronousResponse)resQueue.get(responseTimeout);
                }else{
                    response = (AsynchronousResponse)resQueue.get();
                }
                
                if(response == null){
                    invokeInfo.isTimeout = true;
                    if(isFailToWaitResponseTimeout){
                        throw new AsynchronousTimeoutException();
                    }
                }else{
                    if(response.isThrownException()){
                        throw response.getThrownException();
                    }else{
                        return response.getReturnObject();
                    }
                }
            }
            return null;
        }else{
            return chain.invokeNext(context);
        }
    }
    
    /**
     * Ăяo񓯊ɂ邽߂{@link Queue}T[rXݒ肷B<p>
     *
     * @param queue QueueT[rX
     */
    public void setRequestQueueService(Queue<InvocationInfo> queue){
        this.requestQueue = queue;
    }
    
    /**
     * Ăяo񓯊ɂ邽߂{@link Queue}T[rX擾B<p>
     *
     * @return QueueT[rX
     */
    protected Queue<InvocationInfo> getRequestQueueService(){
        return requestQueue;
    }
    
    /**
     * Ăяo񓯊ɂ邽߂̃ftHg{@link Queue}T[rX擾B<p>
     *
     * @return ftHgQueueT[rX
     */
    protected DefaultQueueService<InvocationInfo> getDefaultRequestQueueService(){
        return defaultRequestQueue;
    }
    
    /**
     * Ăяo񓯊ɂ邽߂̃ftHg{@link Queue}T[rXݒ肷B<p>
     *
     * @param queue ftHgQueueT[rX
     */
    protected void setDefaultRequestQueueService(DefaultQueueService<InvocationInfo> queue){
        defaultRequestQueue = queue;
    }
    
    /**
     * 񓯊Ăяo̖߂i[邽߂{@link Queue}T[rXݒ肷B<p>
     *
     * @param queue QueueT[rX
     */
    public void setResponseQueue(Queue<AsynchronousResponse> queue){
        this.responseQueue = queue;
    }
    
    /**
     * 񓯊Ăяo̖߂i[{߂@link Queue}T[rX擾B<p>
     *
     * @return QueueT[rX
     */
    protected Queue<AsynchronousResponse> getResponseQueue(){
        if(responseQueue != null){
            return responseQueue;
        }
        if(getResponseQueueServiceName() != null){
            return ServiceManagerFactory
                .getServiceObject(getResponseQueueServiceName());
        }
        if(responseTimeout > 0){
            final DefaultQueueService<AsynchronousResponse> tmpQueue = new DefaultQueueService<AsynchronousResponse>();
            try{
                tmpQueue.create();
                tmpQueue.start();
            }catch(Exception e){
                // Ȃ͂
            }
            return tmpQueue;
        }
        return null;
    }
    
    protected class Invoker implements DaemonRunnable<InvocationInfo>{
        
        /**
         * sǂtOB<p>
         */
        public boolean isActive;
        
        /**
         * f[JnɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onStart() {
            return true;
        }
        
        /**
         * f[~ɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onStop() {
            return true;
        }
        
        /**
         * f[fɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onSuspend() {
            return true;
        }
        
        /**
         * f[ĊJɌĂяoB<p>
         * 
         * @return trueԂ
         */
        public boolean onResume() {
            return true;
        }
        
        /**
         * L[PoĕԂB<p>
         * 
         * @param ctrl DaemonControlIuWFNg
         * @return Ăяoi[{@link MethodAsynchronousInterceptorService.InvocationInfo}IuWFNg
         */
        public InvocationInfo provide(DaemonControl ctrl){
            return getRequestQueueService().get();
        }
        
        /**
         * dequeuedœnꂽ{@link MethodAsynchronousInterceptorService.InvocationInfo}IuWFNggāÃC^[Zv^ĂяoB<p>
         * Ăяo̖߂i߂l܂throwꂽOj́A{@link #setResponseQueueServiceName(ServiceName)}{@link Queue}T[rXݒ肳Ă΁AQueueɁA{@link AsynchronousResponse}Ƃċl߂B<br>
         *
         * @param dequeued L[oꂽIuWFNg
         * @param ctrl DaemonControlIuWFNg
         */
        public void consume(InvocationInfo info, DaemonControl ctrl){
            if(info == null){
                return;
            }
            try{
                isActive = true;
                boolean throwException = false;
                Object ret = null;
                try{
                    ret = info.chain.invokeNext(info.context);
                }catch(Throwable e){
                    ret = e;
                    throwException = true;
                }
                final Queue<AsynchronousResponse> resQueue = info.responseQueue;
                if(resQueue != null){
                    AsynchronousResponse response = null;
                    if(throwException){
                        final Class<?>[] exceptionTypes
                             = info.context.getTargetMethod().getExceptionTypes();
                        boolean isThrowable = false;
                        if(RuntimeException.class.isInstance(ret)
                            || Error.class.isInstance(ret)
                        ){
                            isThrowable = true;
                        }else{
                            for(int i = 0; i < exceptionTypes.length; i++){
                                if(exceptionTypes[i].isInstance(ret)){
                                    isThrowable = true;
                                    break;
                                }
                            }
                        }
                        if(isThrowable){
                            response = new AsynchronousResponse(
                                info.context,
                                ret,
                                true
                            );
                        }
                    }else{
                        response = new AsynchronousResponse(info.context, ret);
                    }
                    if(!info.isTimeout && response != null){
                        resQueue.push(response);
                    }
                }
            }finally{
                isActive = false;
            }
        }
        
        /**
         * L[̒gfoB<p>
         */
        public void garbage(){
            if(getRequestQueueService() != null){
                while(getRequestQueueService().size() > 0){
                    consume(getRequestQueueService().get(0), null);
                }
            }
        }
    }
    
    /**
     * ĂяoB<p>
     *
     * @author M.Takata
     */
    protected static class InvocationInfo implements java.io.Serializable{
        
        private static final long serialVersionUID = 7784186054966609415L;
        
        /**
         * {@link Interceptor}̃\bhĂяoB<p>
         */
        public MethodInvocationContext context;
        
        /**
         * C^[Zv^̃`F[B<p>
         */
        public InterceptorChain chain;
        
        /**
         * X|X҂ă^CAEgꍇ
         */
        public volatile boolean isTimeout;
        
        /**
         * QueueB<p>
         */
        public Queue<AsynchronousResponse> responseQueue;
        
        /**
         * Ăяo𐶐B<p>
         *
         * @param context {@link Interceptor}̃\bhĂяo
         * @param chain C^[Zv^̃`F[
         * @param resQueue Queue
         */
        public InvocationInfo(
            MethodInvocationContext context,
            InterceptorChain chain,
            Queue<AsynchronousResponse> resQueue
        ){
            this.context = context;
            this.chain = chain;
            responseQueue = resQueue;
        }
    }
}
