/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor;

import java.util.Properties;
import java.util.Map;
import java.lang.reflect.Method;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.aop.SerializableMethod;

/**
 * {@link MethodMetricsInterceptorService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see MethodMetricsInterceptorService
 */
public interface MethodMetricsInterceptorServiceMBean extends ServiceBaseMBean{
    
    public static final String RECORD_KEY_ORDER = "Order";
    public static final String RECORD_KEY_METHOD = "Method";
    public static final String RECORD_KEY_COUNT = "Count";
    public static final String RECORD_KEY_EXCEPTION_COUNT = "ExceptionCount";
    public static final String RECORD_KEY_ERROR_COUNT = "ErrorCount";
    public static final String RECORD_KEY_LAST_TIME = "LastTime";
    public static final String RECORD_KEY_LAST_EXCEPTION_TIME = "LastExceptionTime";
    public static final String RECORD_KEY_LAST_ERROR_TIME = "LastErrorTime";
    public static final String RECORD_KEY_BEST_PERFORMANCE = "BestPerformance";
    public static final String RECORD_KEY_BEST_PERFORMANCE_TIME = "BestPerformanceTime";
    public static final String RECORD_KEY_WORST_PERFORMANCE = "WorstPerformance";
    public static final String RECORD_KEY_WORST_PERFORMANCE_TIME = "WorstPerformanceTime";
    public static final String RECORD_KEY_AVERAGE_PERFORMANCE = "AveragePerformance";
    
    /**
     * ftHg̓ttH[}bgB<p>
     */
    public static final String DEFAULT_DATE_FORMAT = "HH:mm:ss.SSS";
    
    /**
     * gNX\B<p>
     *
     * @return gNX
     */
    public String displayMetricsInfo();
    
    /**
     * 擾gNXZbgB<p>
     */
    public void reset();
    
    /**
     * gNX擾sǂݒ肷B<p>
     * ftHgł́AtrueB
     *
     * @param enable gNX擾sꍇtrue
     * @see #isEnabled()
     */
    public void setEnabled(boolean enable);
    
    /**
     * gNX擾sǂ𔻒肷B<p>
     *
     * @return gNX擾sꍇtrue
     * @see #setEnabled(boolean)
     */
    public boolean isEnabled();
    
    /**
     * 퉞Ԃꍇԓ̌vZsǂݒ肷B<p>
     * ftHgfalse
     *
     * @param isCalc 퉞Ԃꍇԓ̌vZsꍇ́Atrue
     */
    public void setCalculateOnlyNormal(boolean isCalc);
    
    /**
     * 퉞Ԃꍇԓ̌vZsǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A퉞Ԃꍇԓ̌vZs
     */
    public boolean isCalculateOnlyNormal();
    
    /**
     * o͂鎞̃tH[}bgݒ肷B<p>
     *
     * @param format ttH[}bg
     */
    public void setDateFormat(String format);
    
    /**
     * o͂鎞̃tH[}bg擾B<p>
     *
     * @return ttH[}bg
     */
    public String getDateFormat();
    
    /**
     * w肳ꂽ\bhɊւ郁gNX擾B<p>
     *
     * @param method \bh
     * @return gNX
     */
    public MetricsInfo getMetricsInfo(Method method);
    
    /**
     * SẴgNX擾B<p>
     *
     * @return L[{@link SerializableMethod}AlgNXMap
     */
    public Map<SerializableMethod, MetricsInfo> getMetricsInfos();
    
    /**
     * gNX̏o͎ԊԊu[ms]ݒ肷B<p>
     * ftHǵA60000[ms]B
     *
     * @param interval o͎ԊԊu
     */
    public void setOutputInterval(long interval);
    
    /**
     * gNX̏o͎ԊԊu[ms]擾B<p>
     *
     * @return o͎ԊԊu
     */
    public long getOutputInterval();
    
    /**
     * \bh̃gNX̏o͐}bsOݒ肷B<p>
     * \bh=CategoryT[rX̃T[rX
     *
     * @param mapping \bhƏo͐ƂȂCategoryT[rX̃T[rX̃}bsO
     */
    public void setMethodAndCategoryServiceNameMapping(Properties mapping);
    
    /**
     * \bh̃gNX̏o͐}bsO擾B<p>
     *
     * @return \bhƏo͐ƂȂCategoryT[rX̃T[rX̃}bsO
     */
    public Properties getMethodAndCategoryServiceNameMapping();
    
    /**
     * gNX̏o͐ƂȂCategoryT[rX̃T[rXݒ肷B<p>
     *
     * @param name gNX̏o͐ƂȂCategoryT[rX̃T[rX
     */
    public void setCategoryServiceName(ServiceName name);
    
    /**
     * gNX̏o͐ƂȂCategoryT[rX̃T[rX擾B<p>
     *
     * @return gNX̏o͐ƂȂCategoryT[rX̃T[rX
     */
    public ServiceName getCategoryServiceName();
    
    /**
     * gNXCategoryɏo͂閈ɃgNXZbg邩ǂݒ肷B<p>
     * ftHǵAfalseŁAZbgȂB<br>
     *
     * @param isReset Zbgꍇ́Atrue
     */
    public void setResetByOutput(boolean isReset);
    
    /**
     * gNXCategoryɏo͂閈ɃgNXZbg邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇAZbg
     */
    public boolean isResetByOutput();
    
    /**
     * \bhĂяo񐔁i퉞jo͂邩ǂݒ肷B
     * ftHgtrueB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputCount(boolean isOutput);
    
    /**
     * \bhĂяo񐔁i퉞jo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputCount();
    
    /**
     * \bhĂяo񐔁iOjo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputExceptionCount(boolean isOutput);
    
    /**
     * \bhĂяo񐔁iOjo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputExceptionCount();
    
    /**
     * \bhĂяo񐔁iG[jo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputErrorCount(boolean isOutput);
    
    /**
     * \bhĂяo񐔁iG[jo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputErrorCount();
    
    /**
     * \bhĂяoŏIo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputLastTime(boolean isOutput);
    
    /**
     * \bhĂяoŏIo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputLastTime();
    
    /**
     * OŏIo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputLastExceptionTime(boolean isOutput);
    
    /**
     * OŏIo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputLastExceptionTime();
    
    /**
     * G[ŏIo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputLastErrorTime(boolean isOutput);
    
    /**
     * G[ŏIo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputLastErrorTime();
    
    /**
     * ōԂo͂邩ǂݒ肷B
     * ftHgtrueB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputBestPerformance(boolean isOutput);
    
    /**
     * ōԂo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputBestPerformance();
    
    /**
     * ōo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputBestPerformanceTime(boolean isOutput);
    
    /**
     * ōo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputBestPerformanceTime();
    
    /**
     * ŒᏈԂo͂邩ǂݒ肷B
     * ftHgtrueB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputWorstPerformance(boolean isOutput);
    
    /**
     * ŒᏈԂo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputWorstPerformance();
    
    /**
     * ŒᏈo͂邩ǂݒ肷B
     * ftHgfalseB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputWorstPerformanceTime(boolean isOutput);
    
    /**
     * ŒᏈo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputWorstPerformanceTime();
    
    /**
     * ϏԂo͂邩ǂݒ肷B
     * ftHgtrueB
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputAveragePerformance(boolean isOutput);
    
    /**
     * ϏԂo͂邩ǂ𔻒肷B
     *
     * @return truȅꍇ͏o͂
     */
    public boolean isOutputAveragePerformance();
}
