/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.aop.interceptor.servlet;

import jp.ossc.nimbus.core.*;

/**
 * {@link AccessJournalInterceptorService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 * @see AccessJournalInterceptorService
 */
public interface AccessJournalInterceptorServiceMBean
 extends ServletFilterInterceptorServiceMBean{
    
    /**
     * ANZXW[ĩ[gXebṽL[̃ftHglB<p>
     */
    public static final String DEFAULT_ACCESS_JOURNAL_KEY = "Access";
    
    /**
     * ANZXW[ĩNGXgXebṽL[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_JOURNAL_KEY = "Request";
    
    /**
     * ANZXW[ĩX|XXebṽL[̃ftHglB<p>
     */
    public static final String DEFAULT_RESPONSE_JOURNAL_KEY = "Response";
    
    /**
     * ANZXW[iServletRequestvf̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_SERVLET_REQUEST_JOURNAL_KEY
         = "ServletRequest";
    
    /**
     * ANZXW[iServletResponsevf̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_SERVLET_RESPONSE_JOURNAL_KEY
         = "ServletResponse";
    
    /**
     * ANZXW[iHttpSessionvf̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_HTTP_SESSION_JOURNAL_KEY
         = "HttpSession";
    
    /**
     * ANZXW[iL^ł鎖NGXgB<p>
     */
    public static final String ACCESS_JOURNAL_RECORDED
         = AccessJournalInterceptorService.class.getName() + ".Recorded";
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgID擾ꍇ́ANGXgID̃L[̃ftHglB<p>
     */
    public static final String DEFAULT_REQUEST_ID_KEY
         = ThreadContextKey.REQUEST_ID;
    
    /**
     * ANZXW[ĩ[gXebṽL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_ACCESS_JOURNAL_KEY}B<br>
     *
     * @param key [gXebṽL[
     * @see #DEFAULT_ACCESS_JOURNAL_KEY
     */
    public void setAccessJournalKey(String key);
    
    /**
     * ANZXW[ĩ[gXebṽL[擾B<p>
     *
     * @return [gXebṽL[
     */
    public String getAccessJournalKey();
    
    /**
     * ANZXW[ĩNGXgXebṽL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_JOURNAL_KEY}B<br>
     *
     * @param key NGXgXebṽL[
     * @see #DEFAULT_REQUEST_JOURNAL_KEY
     */
    public void setRequestJournalKey(String key);
    
    /**
     * ANZXW[ĩNGXgXebṽL[擾B<p>
     *
     * @return NGXgXebṽL[
     */
    public String getRequestJournalKey();
    
    /**
     * ANZXW[ĩX|XXebṽL[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_RESPONSE_JOURNAL_KEY}B<br>
     *
     * @param key X|XXebṽL[
     * @see #DEFAULT_RESPONSE_JOURNAL_KEY
     */
    public void setResponseJournalKey(String key);
    
    /**
     * ANZXW[ĩX|XXebṽL[擾B<p>
     *
     * @return X|XXebṽL[
     */
    public String getResponseJournalKey();
    
    /**
     * ANZXW[iServletRequestvf̃L[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SERVLET_REQUEST_JOURNAL_KEY}B<br>
     *
     * @param key ServletRequestvf̃L[
     * @see #DEFAULT_SERVLET_REQUEST_JOURNAL_KEY
     */
    public void setServletRequestJournalKey(String key);
    
    /**
     * ANZXW[iServletRequestvf̃L[擾B<p>
     *
     * @return ServletRequestvf̃L[
     */
    public String getServletRequestJournalKey();
    
    /**
     * ANZXW[iServletResponsevf̃L[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_SERVLET_RESPONSE_JOURNAL_KEY}B<br>
     *
     * @param key ServletResponsevf̃L[
     * @see #DEFAULT_SERVLET_RESPONSE_JOURNAL_KEY
     */
    public void setServletResponseJournalKey(String key);
    
    /**
     * ANZXW[iServletResponsevf̃L[擾B<p>
     *
     * @return ServletResponsevf̃L[
     */
    public String getServletResponseJournalKey();
    
    /**
     * ANZXW[iHttpSessionvf̃L[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_HTTP_SESSION_JOURNAL_KEY}B<br>
     *
     * @param key HttpSessionvf̃L[
     * @see #DEFAULT_HTTP_SESSION_JOURNAL_KEY
     */
    public void setHttpSessionJournalKey(String key);
    
    /**
     * ANZXW[iHttpSessionvf̃L[擾B<p>
     *
     * @return HttpSessionvf̃L[
     */
    public String getHttpSessionJournalKey();
    
    /**
     * {@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JournalT[rX̃T[rX
     */
    public void setJournalServiceName(ServiceName name);
    
    /**
     * {@link jp.ossc.nimbus.service.journal.Journal Journal}T[rX̃T[rX擾B<p>
     *
     * @return JournalT[rX̃T[rX
     */
    public ServiceName getJournalServiceName();
    
    /**
     * ANZXW[ĩ[ggXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     */
    public void setAccessEditorFinderServiceName(ServiceName name);
    
    /**
     * ANZXW[ĩ[gXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     */
    public ServiceName getAccessEditorFinderServiceName();
    
    /**
     * ANZXW[ĩNGXgXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     */
    public void setRequestEditorFinderServiceName(ServiceName name);
    
    /**
     * ANZXW[ĩNGXgXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     */
    public ServiceName getRequestEditorFinderServiceName();
    
    /**
     * ANZXW[ĩX|XXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name EditorFinderT[rX̃T[rX
     */
    public void setResponseEditorFinderServiceName(ServiceName name);
    
    /**
     * ANZXW[ĩX|XXebvҏW{@link jp.ossc.nimbus.service.journal.editorfinder.EditorFinder EditorFinder}T[rX̃T[rX擾B<p>
     *
     * @return EditorFinderT[rX̃T[rX
     */
    public ServiceName getResponseEditorFinderServiceName();
    
    /**
     * NGXgID擾邽߂{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rXݒ肷B<p>
     *
     * @param name SequenceT[rX̃T[rX
     */
    public void setSequenceServiceName(ServiceName name);
    
    /**
     * NGXgID擾邽߂{@link jp.ossc.nimbus.service.sequence.Sequence Sequence}T[rX̃T[rX擾B<p>
     *
     * @return SequenceT[rX̃T[rX
     */
    public ServiceName getSequenceServiceName();
    
    /**
     * NGXgID擾邽߂{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ContextT[rX̃T[rX
     */
    public void setContextServiceName(ServiceName name);
    
    /**
     * NGXgID擾邽߂{@link jp.ossc.nimbus.service.context.Context Context}T[rX̃T[rX擾B<p>
     *
     * @return ContextT[rX̃T[rX
     */
    public ServiceName getContextServiceName();
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgID擾ꍇ́ANGXgID̃L[ݒ肷B<p>
     * ftHǵA{@link #DEFAULT_REQUEST_ID_KEY}B<br>
     *
     * @param key ContextT[rXɊi[ꂽNGXgID̃L[
     * @see #DEFAULT_REQUEST_ID_KEY
     */
    public void setRequestIDKey(String key);
    
    /**
     * {@link jp.ossc.nimbus.service.context.Context Context}T[rX烊NGXgID擾ꍇ́ANGXgID̃L[擾B<p>
     *
     * @return ContextT[rXɊi[ꂽNGXgID̃L[
     */
    public String getRequestIDKey();
    
    /**
     * X|Xbv邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     * X|XbvƁAX|X̏ڍׂȏL^łB<br>
     * L^ł̏ڍׂ́A{@link jp.ossc.nimbus.service.journal.editor.JournalServletResponseWrapper JournalServletResponseWrapper}y{@link jp.ossc.nimbus.service.journal.editor.JournalHttpServletResponseWrapper JournalHttpServletResponseWrapper}QƁB<br>
     *
     * @param isWrap bvꍇ́Atrue
     */
    public void setResponseWrap(boolean isWrap);
    
    /**
     * X|Xbv邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Abv
     */
    public boolean isResponseWrap();
    
    /**
     * X|XbvꍇɁAX|Xւ݂̏obt@O邩ǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isBuffered obt@Oꍇ́Atrue
     */
    public void setResponseBufferedOutput(boolean isBuffered);
    
    /**
     * X|XbvꍇɁAX|Xւ݂̏obt@O邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́Aobt@O
     */
    public boolean isResponseBufferedOutput();
    
    /**
     * 1NGXgɕʉ߂ꍇɁA2ڈȍ~̃W[iL^Ȃǂݒ肷B<p>
     * ftHǵAfalseB<br>
     *
     * @param isBlock L^Ȃꍇ́Atrue
     */
    public void setBushingRequestBlock(boolean isBlock);
    
    /**
     * 1NGXgɕʉ߂ꍇɁA2ڈȍ~̃W[iL^Ȃǂ𔻒肷B<p>
     * ftHǵAfalseB<br>
     *
     * @return truȅꍇ́AL^Ȃ
     */
    public boolean isBushingRequestBlock();
    
    /**
     * NGXg̃ZbVW[iɏo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputRequestSession(boolean isOutput);
    
    /**
     * NGXg̃ZbVW[iɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇo͂
     */
    public boolean isOutputRequestSession();
    
    /**
     * X|X̃ZbVW[iɏo͂邩ǂݒ肷B<p>
     * ftHǵAfalseŏo͂ȂB<br>
     *
     * @param isOutput o͂ꍇtrue
     */
    public void setOutputResponseSession(boolean isOutput);
    
    /**
     * X|X̃ZbVW[iɏo͂邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇo͂
     */
    public boolean isOutputResponseSession();
}