/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.codemaster;

import java.util.*;

/**
 * R[h}X^XVL[B<p>
 *
 * @author M.Takata
 */
public class CodeMasterUpdateKey implements java.io.Serializable{
    
    private static final long serialVersionUID = -4013884085932487915L;
    
    
    /**
     * XVԂ\񋓌^萔łB<p>
     */
    public static enum UpdateType{
        /** ǉ */
        ADD,
        /** ύX */
        UPDATE,
        /** 폜 */
        REMOVE;
    }
    
    private Map<Object, Object> keyMap;
    private UpdateType updateType = UpdateType.UPDATE;
    private Object input;
    
    /**
     * w肳ꂽCfbNX̃L[擾B<p>
     *
     * @param index L[̃CfbNX
     */
    public Object getKey(int index){
        if(index < 0 || keyMap == null || keyMap.size() <= index){
            return null;
        }
        final Iterator<Object> keys = keyMap.values().iterator();
        for(int i = 0; i++ < index; keys.next());
        return keys.next();
    }
    
    /**
     * w肳ꂽÕL[擾B<p>
     *
     * @param name L[̖O
     */
    public Object getKey(String name){
        if(keyMap == null){
            return null;
        }
        return keyMap.get(name);
    }
    
    /**
     * L[̔z擾B<p>
     *
     * @return L[̔z
     */
    public Object[] getKeyArray(){
        if(keyMap == null || keyMap.size() == 0){
            return new Object[0];
        }
        return keyMap.values().toArray();
    }
    
    /**
     * L[̃Xg擾B<p>
     *
     * @return L[̃Xg
     */
    public List<Object> getKeyList(){
        if(keyMap == null || keyMap.size() == 0){
            return new ArrayList<Object>();
        }
        return new ArrayList<Object>(keyMap.values());
    }
    
    /**
     * L[ƃL[̃}bv擾B<p>
     *
     * @return L[ƃL[̃}bv
     */
    public Map<Object, Object> getKeyMap(){
        if(keyMap == null || keyMap.size() == 0){
            return new LinkedHashMap<Object, Object>();
        }
        return new LinkedHashMap<Object, Object>(keyMap);
    }
    
    /**
     * L[̐擾B<p>
     *
     * @return L[̐
     */
    public int getKeySize(){
        return keyMap == null ? 0 : keyMap.size();
    }
    
    /**
     * L[̔zݒ肷B<p>
     *
     * @param keys L[̔z
     */
    public void setKeyArray(Object[] keys){
        if(keys == null || keys.length == 0){
            keyMap = null;
        }else{
            if(keyMap == null){
                keyMap = new LinkedHashMap<Object, Object>();
            }else{
                keyMap.clear();
            }
            for(int i = 0; i < keys.length; i++){
                addKey(keys[i]);
            }
        }
    }
    
    /**
     * L[̃Xgݒ肷B<p>
     *
     * @param keys L[̃Xg
     */
    public void setKeyList(List<Object> keys){
        if(keys == null || keys.size() == 0){
            keyMap = null;
        }else{
            if(keyMap == null){
                keyMap = new LinkedHashMap<Object, Object>();
            }else{
                keyMap.clear();
            }
            for(int i = 0, imax = keys.size(); i < imax; i++){
                addKey(keys.get(i));
            }
        }
    }
    
    /**
     * L[ƃL[̃}bvݒ肷B<p>
     *
     * @param keyMap L[ƃL[̃}bv
     */
    public void setKeyMap(Map<Object, Object> keyMap){
        if(keyMap == null){
            this.keyMap = null;
        }else{
            if(this.keyMap == null){
                this.keyMap = new LinkedHashMap<Object, Object>();
            }else{
                keyMap.clear();
            }
            this.keyMap.putAll(keyMap);
        }
    }
    
    /**
     * L[ǉB<p>
     *
     * @param key L[
     */
    public void addKey(Object key){
        if(keyMap == null){
            keyMap = new LinkedHashMap<Object, Object>();
        }
        keyMap.put(key, key);
    }
    
    /**
     * L[폜B<p>
     *
     * @param index L[̃CfbNX
     */
    public void removeKey(int index){
        if(keyMap == null || keyMap.size() <= index){
            return;
        }
        final Iterator<?> keies = keyMap.keySet().iterator();
        for(int i = 0; keies.hasNext() && i++ < index + 1 ; keies.next());
        keies.remove();
    }
    
    /**
     * L[L[ǉB<p>
     *
     * @param name L[̖O
     * @param key L[
     */
    public void addKey(String name, Object key){
        if(keyMap == null){
            keyMap = new LinkedHashMap<Object, Object>();
        }
        keyMap.put(name, key);
    }
    
    /**
     * L[폜B<p>
     *
     * @param name L[̖O
     */
    public void removeKey(String name){
        if(keyMap == null){
            return;
        }
        keyMap.remove(name);
    }
    
    /**
     * XV^CvǉɂB<p>
     */
    public void add(){
        updateType = UpdateType.ADD;
    }
    
    /**
     * XV^CvύXɂB<p>
     */
    public void update(){
        updateType = UpdateType.UPDATE;
    }
    
    /**
     * XV^Cv폜ɂB<p>
     */
    public void remove(){
        updateType = UpdateType.REMOVE;
    }
    
    /**
     * XV^Cvǉǂ肷B<p>
     *
     * @return XV^CvǉȂtrue
     */
    public boolean isAdd(){
        return updateType == UpdateType.ADD;
    }
    
    /**
     * XV^CvύXǂ肷B<p>
     *
     * @return XV^CvύXȂtrue
     */
    public boolean isUpdate(){
        return updateType == UpdateType.UPDATE;
    }
    
    /**
     * XV^Cv폜ǂ肷B<p>
     *
     * @return XV^Cv폜Ȃtrue
     */
    public boolean isRemove(){
        return updateType == UpdateType.REMOVE;
    }
    
    /**
     * XVp̓̓IuWFNgݒ肷B<p>
     *
     * @param in ̓IuWFNg
     */
    public void setInput(Object in){
        input = in;
    }
    
    /**
     * XVp̓̓IuWFNg擾B<p>
     *
     * @return ̓IuWFNg
     */
    public Object getInput(){
        return input;
    }
    
    /**
     * XV^Cvݒ肷B<p>
     *
     * @param type XV^Cv
     * @see UpdateType#ADD
     * @see UpdateType#UPDATE
     * @see UpdateType#REMOVE
     */
    public void setUpdateType(UpdateType type){
        updateType = type;
    }
    
    /**
     * XV^Cv擾B<p>
     *
     * @return XV^Cv
     * @see UpdateType#ADD
     * @see UpdateType#UPDATE
     * @see UpdateType#REMOVE
     */
    public UpdateType getUpdateType(){
        return updateType;
    }
    
    /**
     * ̃IuWFNg̓eNAB<p>
     */
    public void clear(){
        if(keyMap != null){
            keyMap.clear();
        }
        updateType = UpdateType.UPDATE;
        input = null;
    }
    
    /**
     * ̃IuWFNgƑ̃IuWFNgǂ𔻒肷B<p>
     *
     * @param obj rIuWFNg
     * @return ꍇtrue
     */
    public boolean equals(Object obj){
        if(obj == null){
            return false;
        }
        if(obj == this){
            return true;
        }
        if(!(obj instanceof CodeMasterUpdateKey)){
            return false;
        }
        final CodeMasterUpdateKey cmp = (CodeMasterUpdateKey)obj;
        if(keyMap == null){
            return cmp.keyMap == null;
        }else{
            return keyMap.equals(cmp.keyMap);
        }
    }
    
    /**
     * IuWFNg̃nbVR[hlԂB<p>
     *
     * @return nbVR[h
     */
    public int hashCode(){
        return keyMap == null ? 0 : keyMap.hashCode();
    }
    
    /**
     * IuWFNg̕\ԂB<p>
     *
     * @return \
     */
    public String toString(){
        final StringBuilder buf = new StringBuilder(super.toString());
        buf.append('{');
        buf.append("keyMap=").append(keyMap);
        buf.append(", updateType=");
        buf.append(updateType);
        buf.append('}');
        return buf.toString();
    }
}