/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.graph;

import java.util.Iterator;

/**
 * vbgB<p>
 *
 * @author k2-taniguchi
 */
public interface PlotCondition {

    /**
     * vbg擾B<p>
     *
     * @return vbg
     */
    public String getName();

    /**
     * vbgݒ肷B<p>
     *
     * @param name vbg
     */
    public void setName(String name);

    /**
     * f[^ZbgǉB<p>
     *
     * @param dsCondition f[^Zbg
     */
    public void addDatasetCondition(DatasetCondition dsCondition);

    /**
     * w肳ꂽf[^Zbg̃f[^Zbgz擾B<p>
     *
     * @param dsName f[^Zbg
     * @return f[^Zbgz
     */
    public DatasetCondition[] getDatasetConditions(String dsName);

    /**
     * f[^Zbgz擾B<p>
     *
     * @return f[^Zbgz
     */
    public DatasetCondition[] getDatasetConditions();

    /**
     * f[^Zbg̃Ce[^擾B<p>
     *
     * @return f[^Zbg̃Ce[^
     */
    public Iterator<String> getDatasetNames();

    /**
     * Lȃf[^Zbgz擾B<p>
     *
     * @return Lȃf[^Zbgz
     */
    public String[] getEnableDatasetNames();

    /**
     * Lȃf[^ZbgǉB<p>
     *
     * @param dsName Lȃf[^Zbg
     */
    public void addEnableDatasetName(String dsName);

    /**
     * ݒ菇̃f[^Zbgz擾B<p>
     *
     * @return f[^Zbgz
     */
    public String[] getDatasetNameOrder();

    /**
     * Cӂ̐ݒ菇Ńf[^ZbgǉB<p>
     *
     * @param dsName f[^Zbg
     */
    public void addDatasetNameOrder(String dsName);

}
