/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.io;

import java.io.ObjectInput;
import java.io.ObjectOutput;

import jp.ossc.nimbus.core.ServiceBaseMBean;

/**
 * {@link SerializableExternalizerService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see SerializableExternalizerService
 */
public interface SerializableExternalizerServiceMBean extends ServiceBaseMBean{
    
    /**
     * k[hF񈳏kB<p>
     */
    public static final int COMPRESS_MODE_NONE = 0;
    
    /**
     * k[hFZLIB`B<p>
     */
    public static final int COMPRESS_MODE_ZLIB = 1;
    
    /**
     * k[hFZIP`B<p>
     */
    public static final int COMPRESS_MODE_ZIP = 2;
    
    /**
     * k[hFGZIP`B<p>
     */
    public static final int COMPRESS_MODE_GZIP = 3;
    
    /**
     * k[hݒ肷B<p>
     * ftHǵA{@link #COMPRESS_MODE_NONE 񈳏k}B<br>
     * 
     * @param mode k[h
     * @see #COMPRESS_MODE_NONE
     * @see #COMPRESS_MODE_ZLIB
     * @see #COMPRESS_MODE_ZIP
     * @see #COMPRESS_MODE_GZIP
     */
    public void setCompressMode(int mode);
    
    /**
     * k[h擾B<p>
     * 
     * @return k[h
     */
    public int getCompressMode();
    
    /**
     * kxݒ肷B<p>
     * ftHǵA{@link java.util.zip.Deflater#DEFAULT_COMPRESSION}B<br>
     * k[hA{@link #COMPRESS_MODE_ZLIB}A{@link #COMPRESS_MODE_ZIP}̏ꍇALB<br>
     * 
     * @param level kx
     */
    public void setCompressLevel(int level);
    
    /**
     * kx擾B<p>
     * 
     * @return kx
     */
    public int getCompressLevel();
    
    /**
     * k\bhݒ肷B<p>
     * ftHǵA{@link java.util.zip.ZipOutputStream#DEFLATED}B<br>
     * k[hA{@link #COMPRESS_MODE_ZIP}̏ꍇ̂݁ALB<br>
     * 
     * @param method k\bh
     */
    public void setCompressMethod(int method);
    
    /**
     * k\bh擾B<p>
     * 
     * @return k\bh
     */
    public int getCompressMethod();
    
    /**
     * k臒lݒ肷B<p>
     * k臒l𒴂oCgƂȂIuWFNĝ݈kB<br>
     * ftHǵA-1őSĈkB<br>
     *
     * @param threshold k臒l[byte]
     */
    public void setCompressThreshold(int threshold);
    
    /**
     * k臒l擾B<p>
     * 
     * @return k臒l[byte]
     */
    public int getCompressThreshold();
    
    /**
     * o͂̃obt@TCYݒ肷B<p>
     * 
     * @param size obt@TCY
     */
    public void setBufferSize(int size);
    
    /**
     * o͂̃obt@TCY擾B<p>
     * 
     * @return obt@TCY
     */
    public int getBufferSize();
    
    /**
     * {@link Externalizer#writeExternal(Object, java.io.OutputStream)}ĂяoꂽۂɁAjava.io.OutputStreambvjava.io.ObjectOutput̎NXݒ肷B<p>
     * ŁAw肷java.io.ObjectOutput̎NX́Ajava.io.OutputStreamRXgN^KvB<br>
     * ftHǵAnullŁAjava.io.ObjectOutputStreamgpB<br>
     *
     * @param clazz java.io.ObjectOutput̎NX
     */
    public void setObjectOutputClass(Class<? extends ObjectOutput> clazz);
    
    /**
     * {@link Externalizer#writeExternal(Object, java.io.OutputStream)}ĂяoꂽۂɁAjava.io.OutputStreambvjava.io.ObjectOutput̎NX擾B<p>
     *
     * @return java.io.ObjectOutput̎NX
     */
    public Class<? extends ObjectOutput> getObjectOutputClass();
    
    /**
     * {@link Externalizer#readExternal(java.io.InputStream)}ĂяoꂽۂɁAjava.io.InputStreambvjava.io.ObjectInput̎NXݒ肷B<p>
     * ŁAw肷java.io.ObjectInput̎NX́Ajava.io.InputStreamRXgN^KvB<br>
     * ftHǵAnullŁAjava.io.ObjectInputStreamgpB<br>
     *
     * @param clazz java.io.ObjectInput̎NX
     */
    public void setObjectInputClass(Class<? extends ObjectInput> clazz);
    
    /**
     * {@link Externalizer#readExternal(java.io.InputStream)}ĂяoꂽۂɁAjava.io.InputStreambvjava.io.ObjectInput̎NX擾B<p>
     *
     * @return java.io.ObjectInput̎NX
     */
    public Class<? extends ObjectInput> getObjectInputClass();
}
