/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.jmx;

import java.util.Map;
import javax.management.QueryExp;
import javax.management.MalformedObjectNameException;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link MBeanWatcherService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface MBeanWatcherServiceMBean extends ServiceBaseMBean{
    
    public static final String MSG_ID_GET_VALUE_ERROR = "MBW__00001";
    public static final String MSG_ID_CONNECT_ERROR   = "MBW__00002";
    public static final String MSG_ID_WRITE_ERROR     = "MBW__00003";
    public static final String MSG_ID_CHECK_WARN      = "MBW__00004";
    public static final String MSG_ID_CHECK_ERROR     = "MBW__00005";
    public static final String MSG_ID_CHECK_FATAL     = "MBW__00006";
    
    /**
     * javax.management.MBeanServerConnectionJNDĨftHglB<p>
     */
    public static final String DEFAULT_JMX_RMI_ADAPTOR_NAME = "jmx/invoker/RMIAdaptor";
    
    /**
     * javax.management.MBeanServerConnectionJNDIlookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rXݒ肷B<p>
     *
     * @param name JndiFinderT[rX̃T[rX
     */
    public void setJndiFinderServiceName(ServiceName name);
    
    /**
     * javax.management.MBeanServerConnectionJNDIlookup{@link jp.ossc.nimbus.service.jndi.JndiFinder JndiFinder}T[rX̃T[rX擾B<p>
     *
     * @return JndiFinderT[rX̃T[rX
     */
    public ServiceName getJndiFinderServiceName();
    
    /**
     * javax.management.MBeanServerConnectionJNDIݒ肷B<p>
     * ftHǵA{@link #DEFAULT_JMX_RMI_ADAPTOR_NAME}B<br>
     *
     * @param name javax.management.MBeanServerConnectionJNDI
     */
    public void setRMIAdaptorName(String name);
    
    /**
     * javax.management.MBeanServerConnectionJNDI擾B<p>
     *
     * @return javax.management.MBeanServerConnectionJNDI
     */
    public String getRMIAdaptorName();
    
    /**
     * ڑJMXT[õT[rXURLݒ肷B<p>
     *
     * @param url T[rXURL
     */
    public void setServiceURL(String url);
    
    /**
     * ڑJMXT[õT[rXURL擾B<p>
     *
     * @return T[rXURL
     */
    public String getServiceURL();
    
    /**
     * ڑJMXT[o̐ڑϐݒ肷B<p>
     *
     * @param env ڑϐ
     */
    public void setJMXConnectorEnvironment(Map<String, ?> env);
    
    /**
     * ڑJMXT[o̐ڑϐ擾B<p>
     *
     * @return ڑϐ
     */
    public Map<String, ?> getJMXConnectorEnvironment();
    
    /**
     * ĎԊuݒ肷B<p>
     * ftHg0ŁAIɊĎȂB<br>
     *
     * @param interval ĎԊu[ms]
     */
    public void setInterval(long interval);
    
    /**
     * ĎԊu擾B<p>
     *
     * @return ĎԊu[ms]
     */
    public long getInterval();
    
    /**
     * Ďʂo͂{@link jp.ossc.nimbus.service.writer.Category Category}T[rX̃T[rXݒ肷B<p>
     * w肵Ȃꍇ́AĎʂ͏o͂ȂB<br>
     * 
     * @param name CategoryT[rX̃T[rX
     */
    public void setCategoryServiceName(ServiceName name);
    
    /**
     * Ďʂo͂{@link jp.ossc.nimbus.service.writer.Category Category}T[rX̃T[rX擾B<p>
     * 
     * @return CategoryT[rX̃T[rX
     */
    public ServiceName getCategoryServiceName();
    
    /**
     * T[rX̊JnJMXڑmĂǂݒ肷B<p>
     * ftHǵAfalseŁAĎɖڑsBRMIAdaptoroRł̐ڑ̏ꍇ́AB<br>
     * 
     * @param isConnect T[rX̊JnJMXڑmꍇ́Atrue
     */
    public void setConnectOnStart(boolean isConnect);
    
    /**
     * T[rX̊JnJMXڑmĂǂ𔻒肷B<p>
     * 
     * @return truȅꍇAT[rX̊JnJMXڑm
     */
    public boolean isConnectOnStart();
    
    /**
     * ĎΏۂ̒l擾ۂɃG[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_GET_VALUE_ERROR}B<br>
     * 
     * @param id ÕbZ[WID
     */
    public void setGetValueErrorMessageId(String id);
    
    /**
     * ĎΏۂ̒l擾ۂɃG[ꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getGetValueErrorMessageId();
    
    /**
     * ĎΏۂ̒l擾ۂJMXT[oւ̐ڑG[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_CONNECT_ERROR}B<br>
     * 
     * @param id ÕbZ[WID
     */
    public void setConnectErrorMessageId(String id);
    
    /**
     * ĎΏۂ̒l擾ۂJMXT[oւ̐ڑG[ꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getConnectErrorMessageId();
    
    /**
     * Ďʂo͂ۂɃG[ꍇɏo͂郍ÕbZ[WIDݒ肷B<p>
     * ftHǵA{@link #MSG_ID_WRITE_ERROR}B<br>
     * 
     * @param id ÕbZ[WID
     */
    public void setWriteErrorMessageId(String id);
    
    /**
     * Ďʂo͂ۂɃG[ꍇɏo͂郍ÕbZ[WID擾B<p>
     * 
     * @return ÕbZ[WID
     */
    public String getWriteErrorMessageId();
    
    /**
     * ĎΏۂManaged BeanWƂĈǂݒ肷B<p>
     * ftHǵAfalseŁAĎΏۂ́AӂManaged BeanB<br>
     *
     * @param isSet ĎΏۂManaged BeanWƂĈꍇtrue
     */
    public void setMBeanSet(boolean isSet);
    
    /**
     * ĎΏۂManaged BeanWƂĈǂ𔻒肷B<p>
     *
     * @return truȅꍇAĎΏۂManaged BeanWƂĈ
     */
    public boolean isMBeanSet();
    
    /**
     * ĎΏۂManaged Bean̖Oݒ肷B<p>
     * {@link #setMBeanSet(boolean) setMBeanSet(false)}Ɛݒ肵Ăꍇ́AManaged Beanӂɓ肷銮Sw肷B<br>
     * {@link #setMBeanSet(boolean) setMBeanSet(true)}Ɛݒ肵Ăꍇ́AManaged Bean̏W肷IuWFNgw肷B<br>
     *
     * @param name Managed Bean̖OJMX̃IuWFNg`Ŏw肷
     * @exception MalformedObjectNameException IuWFNgsȏꍇ
     */
    public void setObjectName(String name) throws MalformedObjectNameException;
    
    /**
     * ĎΏۂManaged Bean̖O擾B<p>
     *
     * @return Managed Bean̖OJMX̃IuWFNg`Ŏw肷
     */
    public String getObjectName();
    
    /**
     * ĎΏۂManaged Beani荞ޏݒ肷B<p>
     * {@link #setMBeanSet(boolean) setMBeanSet(true)}̏ꍇ̂ݗLB<br>
     *
     * @param exp 
     */
    public void setQueryExp(QueryExp exp);
    
    /**
     * ĎΏۂManaged Beani荞ޏ擾B<p>
     *
     * @return 
     */
    public QueryExp getQueryExp();
    
    /**
     * ĎΏۂ̃}bv擾B<p>
     *
     * @return L[ĎΏۃL[Al{@link MBeanWatcherService.Target ĎΏ}̃}bv
     */
    public Map<String, MBeanWatcherService.Target> getTargetMap();
    
    /**
     * ĎsB<p>
     *
     * @return L[ĎΏۃL[AlĎΏۂ̒lƂȂĎʃ}bv
     * @exception Exception ĎsɎsꍇ
     */
    public Map<String, Object> watch() throws Exception;
    
    /**
     * ĎsAĎʂo͂B<p>
     * {@link jp.ossc.nimbus.service.writer.Category Category}T[rXݒ肳ĂȂꍇ́AĎʂ̏o͍͂sȂB<br>
     *
     * @exception Exception Ďs܂͊Ďʂ̏o͂Ɏsꍇ
     */
    public void write() throws Exception;
    
    /**
     * ĎԂZbgB<p>
     */
    public void reset();
}