/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectOutput;
import java.io.ObjectInput;

import jp.ossc.nimbus.core.Service;
import jp.ossc.nimbus.core.ServiceName;
import jp.ossc.nimbus.core.ServiceManagerFactory;

/**
 * W[iB<p>
 *
 * @author M.Takata
 */
public class JournalInfoImpl implements JournalInfo, Externalizable{
    
    protected String key;
    protected Object value;
    protected boolean isEdit;
    protected JournalEditor editor;
    
    public JournalInfoImpl(){
    }
    
    public JournalInfoImpl(String key, Object val){
        this.key = key;
        value = val;
    }
    
    @Override
    public String getKey(){
        return key;
    }
    
    public void setKey(String key){
        this.key = key;
    }
    
    @Override
    public Object getValue(){
        return value;
    }
    
    public void setValue(Object val){
        value = val;
    }
    
    @Override
    public JournalEditor getJournalEditor(){
        return editor;
    }
    
    @Override
    public Object toObject(EditorFinder finder){
        if(isEdit){
            return value;
        }
        isEdit = true;
        editor = finder.findEditor(
            getKey(),
            getValue()
        );
        if(editor != null){
            value = editor.toObject(finder, getKey(), getValue());
        }
        return value;
    }
    
    @Override
    public String toString(){
        return super.toString() + '{' + "key=" + key + ",value=" + value + '}';
    }
    
    @Override
    public void writeExternal(ObjectOutput out) throws IOException{
        out.writeObject(key);
        out.writeObject(value);
        out.writeBoolean(isEdit);
        if(editor != null){
            if(editor instanceof Service){
                Service service = (Service)editor;
                ServiceName name = service.getServiceNameObject();
                if(name.getServiceManagerName() == null){
                    out.writeObject(editor);
                }else{
                    out.writeObject(name);
                }
            }else{
                out.writeObject(editor);
            }
        }else{
            out.writeObject(editor);
        }
    }
    
    @Override
    public void readExternal(ObjectInput in)
     throws IOException, ClassNotFoundException{
        key = (String)in.readObject();
        value = in.readObject();
        isEdit = in.readBoolean();
        Object obj = in.readObject();
        if(obj instanceof ServiceName){
            editor = ServiceManagerFactory.getServiceObject(
                (ServiceName)obj
            );
        }else{
            editor = (JournalEditor)obj;
        }
    }
}
