/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;

import javax.servlet.ServletRequest;

import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * {@link ServletRequest}JSON`ɕҏWW[iGfB^[B<p>
 *
 * @author M.Takata
 */
public class ServletRequestJSONJournalEditorService
 extends JSONJournalEditorService
 implements ServletRequestJSONJournalEditorServiceMBean{
    
    private static final long serialVersionUID = 2065586363258892183L;
    
    protected String[] secretAttributes;
    protected Set<String> secretAttributeSet;
    protected String[] enabledAttributes;
    protected Set<String> enabledAttributeSet;
    protected String[] disabledAttributes;
    protected Set<String> disabledAttributeSet;
    protected String[] secretParameters;
    protected Set<String> secretParameterSet;
    protected String[] enabledParameters;
    protected Set<String> enabledParameterSet;
    protected String[] disabledParameters;
    protected Set<String> disabledParameterSet;
    
    @Override
    public void setSecretAttributes(String[] names){
        secretAttributes = names;
    }
    
    @Override
    public String[] getSecretAttributes(){
        return secretAttributes;
    }
    
    @Override
    public void setEnabledAttributes(String[] names){
        enabledAttributes = names;
    }
    
    @Override
    public String[] getEnabledAttributes(){
        return enabledAttributes;
    }
    
    @Override
    public void setDisabledAttributes(String[] names){
        disabledAttributes = names;
    }
    
    @Override
    public String[] getDisabledAttributes(){
        return disabledAttributes;
    }
    
    @Override
    public void setSecretParameters(String[] names){
        secretParameters = names;
    }
    
    @Override
    public String[] getSecretParameters(){
        return secretParameters;
    }
    
    @Override
    public void setEnabledParameters(String[] names){
        enabledParameters = names;
    }
    
    @Override
    public String[] getEnabledParameters(){
        return enabledParameters;
    }
    
    @Override
    public void setDisabledParameters(String[] names){
        disabledParameters = names;
    }
    
    @Override
    public String[] getDisabledParameters(){
        return disabledParameters;
    }
    
    @Override
    public void startService() throws Exception{
        if(secretAttributes != null && secretAttributes.length != 0){
            secretAttributeSet = new HashSet<String>(secretAttributes.length);
            for(String attr : secretAttributes){
                secretAttributeSet.add(attr);
            }
        }
        if(enabledAttributes != null && enabledAttributes.length != 0){
            enabledAttributeSet = new HashSet<String>(enabledAttributes.length);
            for(String attr : enabledAttributes){
                enabledAttributeSet.add(attr);
            }
        }
        if(disabledAttributes != null && disabledAttributes.length != 0){
            disabledAttributeSet = new HashSet<String>(disabledAttributes.length);
            for(String attr : disabledAttributes){
                disabledAttributeSet.add(attr);
            }
        }
        if(secretParameters != null && secretParameters.length != 0){
            secretParameterSet = new HashSet<String>(secretParameters.length);
            for(String attr : secretParameters){
                secretParameterSet.add(attr);
            }
        }
        if(enabledParameters != null && enabledParameters.length != 0){
            enabledParameterSet = new HashSet<String>(enabledParameters.length);
            for(String attr : enabledParameters){
                enabledParameterSet.add(attr);
            }
        }
        if(disabledParameters != null && disabledParameters.length != 0){
            disabledParameterSet = new HashSet<String>(disabledParameters.length);
            for(String attr : disabledParameters){
                disabledParameterSet.add(attr);
            }
        }
    }
    
    protected boolean isOutputAttribute(String name){
        if(name != null
            && disabledAttributeSet != null
            && disabledAttributeSet.contains(name)
        ){
            return false;
        }
        if(name != null
            && enabledAttributeSet != null
            && !enabledAttributeSet.contains(name)
        ){
            return false;
        }
        return true;
    }
    
    protected boolean isSecretAttribute(String name){
        return name != null && secretAttributeSet != null && secretAttributeSet.contains(name);
    }
    
    protected boolean isOutputParameter(String name){
        if(name != null
            && disabledParameterSet != null
            && disabledParameterSet.contains(name)
        ){
            return false;
        }
        if(name != null
            && enabledParameterSet != null
            && !enabledParameterSet.contains(name)
        ){
            return false;
        }
        return true;
    }
    
    protected boolean isSecretParameter(String name){
        return name != null && secretParameterSet != null && secretParameterSet.contains(name);
    }
    
    @Override
    protected StringBuilder appendUnknownValue(StringBuilder buf, EditorFinder finder, Class<?> type, Object value, Stack<Object> stack){
        if(!(value instanceof ServletRequest)){
            return super.appendUnknownValue(buf, finder, type, value, stack);
        }
        final ServletRequest request = (ServletRequest)value;
        
        buf.append(OBJECT_ENCLOSURE_START);
        appendServletRequest(buf, finder, request, false, stack);
        buf.append(OBJECT_ENCLOSURE_END);
        return buf;
    }
    
    protected boolean appendServletRequest(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        isAppended |= appendSentServer(buf, finder, request, isAppended, stack);
        isAppended |= appendReceivedServer(buf, finder, request, isAppended, stack);
        isAppended |= appendHost(buf, finder, request, isAppended, stack);
        isAppended |= appendProtocol(buf, finder, request, isAppended, stack);
        isAppended |= appendScheme(buf, finder, request, isAppended, stack);
        isAppended |= appendLocale(buf, finder, request, isAppended, stack);
        isAppended |= appendContentType(buf, finder, request, isAppended, stack);
        isAppended |= appendContentLength(buf, finder, request, isAppended, stack);
        isAppended |= appendCharacterEncoding(buf, finder, request, isAppended, stack);
        isAppended |= appendAttributes(buf, finder, request, isAppended, stack);
        isAppended |= appendParameters(buf, finder, request, isAppended, stack);
        return isAppended;
    }
    
    protected boolean appendSentServer(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_SENT_SERVER)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_SENT_SERVER,
                request.getRemoteAddr() + ":" + request.getRemotePort(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendReceivedServer(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_RECEIVED_SERVER)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_RECEIVED_SERVER,
                request.getLocalAddr() + ":" + request.getLocalPort() + "(" + request.getLocalName() + ")",
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendHost(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_HOST)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_HOST,
                request.getServerName() + ":" + request.getServerPort(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendProtocol(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_PROTOCOL)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_PROTOCOL,
                request.getProtocol(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendScheme(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_SCHEME)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_SCHEME,
                request.getScheme(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendLocale(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_LOCALE)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendName(buf, PROPERTY_LOCALE);
            buf.append(PROPERTY_SEPARATOR);
            appendArray(buf, finder, request.getLocales(), stack);
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendContentType(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_CONTENT_TYPE)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_CONTENT_TYPE,
                request.getContentType(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendContentLength(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_CONTENT_LENGTH)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_CONTENT_LENGTH,
                request.getContentLength(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    protected boolean appendCharacterEncoding(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_CHARACTER_ENCODING)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendProperty(
                buf,
                finder,
                PROPERTY_CHARACTER_ENCODING,
                request.getCharacterEncoding(),
                stack
            );
            return true;
        }else{
            return false;
        }
    }
    
    @SuppressWarnings("unchecked")
    protected boolean appendAttributes(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_ATTRIBUTES)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendName(buf, PROPERTY_ATTRIBUTES);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            final Enumeration<String> names = (Enumeration<String>)request.getAttributeNames();
            boolean isOutput = false;
            while(names.hasMoreElements()){
                String name = names.nextElement();
                if(!isOutputAttribute(name)){
                    continue;
                }
                if(isOutput){
                    buf.append(ARRAY_SEPARATOR);
                }
                isOutput = true;
                appendName(buf, name);
                buf.append(PROPERTY_SEPARATOR);
                if(isSecretAttribute(name)){
                    appendValue(buf, finder, null, secretString, stack);
                }else{
                    appendValue(buf, finder, null, request.getAttribute(name), stack);
                }
            }
            buf.append(OBJECT_ENCLOSURE_END);
            return true;
        }else{
            return false;
        }
    }
    
    @SuppressWarnings("unchecked")
    protected boolean appendParameters(StringBuilder buf, EditorFinder finder, ServletRequest request, boolean isAppended, Stack<Object> stack){
        if(isOutputProperty(PROPERTY_PARAMETERS)){
            if(isAppended){
                buf.append(ARRAY_SEPARATOR);
            }
            appendName(buf, PROPERTY_PARAMETERS);
            buf.append(PROPERTY_SEPARATOR);
            buf.append(OBJECT_ENCLOSURE_START);
            final Enumeration<String> names = (Enumeration<String>)request.getParameterNames();
            boolean isOutput = false;
            while(names.hasMoreElements()){
                String name = names.nextElement();
                if(!isOutputParameter(name)){
                    continue;
                }
                if(isOutput){
                    buf.append(ARRAY_SEPARATOR);
                }
                isOutput = true;
                appendName(buf, name);
                buf.append(PROPERTY_SEPARATOR);
                if(isSecretParameter(name)){
                    appendValue(buf, finder, null, secretString, stack);
                }else{
                    appendArray(buf, finder, request.getParameterValues(name), stack);
                }
            }
            buf.append(OBJECT_ENCLOSURE_END);
            return true;
        }else{
            return false;
        }
    }
}