/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.journal.editor;

import java.io.Serializable;
import java.util.*;
import javax.servlet.ServletResponse;

import jp.ossc.nimbus.service.journal.EditorFinder;

/**
 * ServletResponseIuWFNgMaptH[}bgGfB^B<p>
 * ̃GfB^ɂĕҏWꂽMaṕAȉ̍\B<br>
 * <table broder="1">
 *   <tr bgcolor="#CCCCFF"><th colspan="2">L[</th><th colspan="2">l</th></tr>
 *   <tr bgcolor="#CCCCFF"><th>^</th><th>e</th><th>^</th><th>e</th></tr>
 *   <tr><td>java.lang.String</td><td>{@link #BUFFER_SIZE_KEY}</td><td>java.lang.Integer</td><td>obt@TCY</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #CONTENT_TYPE_KEY}</td><td>java.lang.String</td><td>Reg</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #CHARACTER_ENCODING_KEY}</td><td>java.lang.String</td><td>GR[fBO</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #LOCALE_KEY}</td><td>java.util.Locale</td><td>P[</td></tr>
 *   <tr><td>java.lang.String</td><td>{@link #IS_COMMITTED_KEY}</td><td>java.lang.Boolean</td><td>X|XR~bgĂ邩ǂ̃tO</td></tr>
 * </table>
 * AAo͂Ȃ悤ɐݒ肳Ă̂AServletResponseɊ܂܂ĂȂAJ2EẼo[WɂĎ擾łȂ͊܂܂ȂB<br>
 * 
 * @author M.Takata
 */
public class ServletResponseMapJournalEditorService
 extends MapJournalEditorServiceBase
 implements ServletResponseMapJournalEditorServiceMBean, Serializable{
    
    private static final long serialVersionUID = -2652120436180972791L;
    
    /**
     * W[iƂė^ꂽServletResponse^̏W[iƂďo͂MapɕϊB<br>
     * 
     * @param finder K؂JournalEditor񋟂EditorFinder
     * @param key W[ĩL[
     * @param value W[i
     * @return W[iƂďo͂Map
     */
    @Override
    protected Map<String, Object> toMap(EditorFinder finder, String key, Object value){
        final ServletResponse response = (ServletResponse)value;
        final Map<String, Object> result = new LinkedHashMap<String, Object>();
        makeBufferSizeFormat(finder, key, response, result);
        makeCharacterEncodingFormat(finder, key, response, result);
        makeContentTypeFormat(finder, key, response, result);
        makeLocaleFormat(finder, key, response, result);
        makeIsCommittedFormat(finder, key, response, result);
        
        return result;
    }
    
    protected Map<String, Object> makeBufferSizeFormat(
        EditorFinder finder,
        String key,
        ServletResponse response,
        Map<String, Object> map
    ){
        putMap(map, BUFFER_SIZE_KEY, response.getBufferSize());
        return map;
    }
    
    protected Map<String, Object> makeCharacterEncodingFormat(
        EditorFinder finder,
        String key,
        ServletResponse response,
        Map<String, Object> map
    ){
        putMap(map, CHARACTER_ENCODING_KEY, response.getCharacterEncoding());
        return map;
    }
    
    protected Map<String, Object> makeContentTypeFormat(
        EditorFinder finder,
        String key,
        ServletResponse response,
        Map<String, Object> map
    ){
        putMap(map, CONTENT_TYPE_KEY, response.getContentType());
        return map;
    }
    
    protected Map<String, Object> makeLocaleFormat(
        EditorFinder finder,
        String key,
        ServletResponse response,
        Map<String, Object> map
    ){
        putMap(map, 
            LOCALE_KEY,
            makeObjectFormat(finder, key, response.getLocale())
        );
        return map;
    }
    
    protected Map<String, Object> makeIsCommittedFormat(
        EditorFinder finder,
        String key,
        ServletResponse response,
        Map<String, Object> map
    ){
        putMap(map, IS_COMMITTED_KEY, response.isCommitted() ? Boolean.TRUE : Boolean.FALSE);
        return map;
    }
}
