/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.log;

import jp.ossc.nimbus.core.*;

/**
 * {@link DefaultCommonsLogFactoryService}MBeanC^tF[XB<p>
 * 
 * @author M.Takata
 */
public interface DefaultCommonsLogFactoryServiceMBean extends DefaultLoggerServiceMBean{
    
    public static final String CATEGORY_COMMONS_TRACE
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_TRACE";
    public static final String CATEGORY_COMMONS_DEBUG
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_DEBUG";
    public static final String CATEGORY_COMMONS_INFO
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_INFO";
    public static final String CATEGORY_COMMONS_WARN
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_WARN";
    public static final String CATEGORY_COMMONS_ERROR
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_ERROR";
    public static final String CATEGORY_COMMONS_FATAL
     = "jp.ossc.nimbus.service.log.DefaultCommonsLogService.CATEGORY_COMMONS_FATAL";
    
    public static final int PRIORITY_COMMONS_TRACE_MIN = 0;
    public static final int PRIORITY_COMMONS_TRACE_MAX = 9;
    public static final int PRIORITY_COMMONS_TRACE = 5;
    
    public static final int PRIORITY_COMMONS_DEBUG_MIN = 10;
    public static final int PRIORITY_COMMONS_DEBUG_MAX = 19;
    public static final int PRIORITY_COMMONS_DEBUG = 15;
    
    public static final int PRIORITY_COMMONS_INFO_MIN = 20;
    public static final int PRIORITY_COMMONS_INFO_MAX = 29;
    public static final int PRIORITY_COMMONS_INFO = 25;
    
    public static final int PRIORITY_COMMONS_WARN_MIN = 30;
    public static final int PRIORITY_COMMONS_WARN_MAX = 39;
    public static final int PRIORITY_COMMONS_WARN = 35;
    
    public static final int PRIORITY_COMMONS_ERROR_MIN = 40;
    public static final int PRIORITY_COMMONS_ERROR_MAX = 49;
    public static final int PRIORITY_COMMONS_ERROR = 45;
    
    public static final int PRIORITY_COMMONS_FATAL_MIN = 50;
    public static final int PRIORITY_COMMONS_FATAL_MAX = 59;
    public static final int PRIORITY_COMMONS_FATAL = 55;
    
    public static final String LABEL_COMMONS_TRACE = "TRACE";
    public static final String LABEL_COMMONS_DEBUG = "DEBUG";
    public static final String LABEL_COMMONS_INFO = "INFO";
    public static final String LABEL_COMMONS_WARN = "WARN";
    public static final String LABEL_COMMONS_ERROR = "ERROR";
    public static final String LABEL_COMMONS_FATAL = "FATAL";
    
    /**
     * OT[rX̃NCAgʂL[\o̓tH[}bg̃L[B<p> 
     */
    public static final String FORMAT_CLIENT_KEY = "CLIENT";
    
    /**
     * ftHgtH[}bgB<p>
     * "%DATE%,%CLIENT%,%PRIORITY%,%MESSAGE%"
     */
    public static final String DEFAULT_FORMAT
         = '%' + FORMAT_DATE_KEY + "%,%" + FORMAT_CLIENT_KEY + "%,%"
          + FORMAT_PRIORITY_KEY + "%,%" + FORMAT_MESSAGE_KEY + '%';
    
    /**
     * w肳ꂽONCAg̃Oo͂悤ɐݒ肷B<p>
     *
     * @param clients {@link org.apache.commons.logging.LogFactory#getLog(String)}̈̕A܂{@link org.apache.commons.logging.LogFactory#getLog(Class)}̈̃NX̃pbP[WNX
     */
    public void setEnabledClients(String[] clients);
    
    /**
     * LȃONCAg̃L[z擾B<p>
     *
     * @return LȃONCAg̃L[z
     */
    public String[] getEnabledClients();
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsTraceEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsTraceEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsDebugEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsDebugEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsInfoEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsInfoEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsWarnEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsWarnEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsErrorEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsErrorEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo͂sǂݒ肷B<p>
     *
     * @param isEnabled o͂ꍇ true
     */
    public void setCommonsFatalEnabled(boolean isEnabled);
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo͂sǂ𒲂ׂB<p>
     *
     * @return o͂ꍇ true
     */
    public boolean isCommonsFatalEnabled();
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsTraceMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsTraceMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsDebugMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsDebugMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsInfoMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsInfoMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsWarnMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsWarnMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsErrorMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsErrorMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rXݒ肷B<p>
     *
     * @param name MessageWriterT[rX
     */
    public void setCommonsFatalMessageWriterServiceName(ServiceName name);
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo͂s{@link jp.ossc.nimbus.service.writer.MessageWriter MessageWriter}T[rX擾B<p>
     *
     * @return MessageWriterT[rX
     */
    public ServiceName getCommonsFatalMessageWriterServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsTraceWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#trace(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsTraceWritableRecordFactoryServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsDebugWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#debug(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsDebugWritableRecordFactoryServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsInfoWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#info(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsInfoWritableRecordFactoryServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsWarnWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#warn(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsWarnWritableRecordFactoryServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsErrorWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#error(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsErrorWritableRecordFactoryServiceName();
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rXݒ肷B<p>
     *
     * @param name WritableRecordFactoryT[rX
     */
    public void setCommonsFatalWritableRecordFactoryServiceName(
        ServiceName name
    );
    
    /**
     * {@link org.apache.commons.logging.Log#fatal(Object)}̃Oo̓tH[}bgs{@link jp.ossc.nimbus.service.writer.WritableRecordFactory WritableRecordFactory}T[rX擾B<p>
     *
     * @return WritableRecordFactoryT[rX
     */
    public ServiceName getCommonsFatalWritableRecordFactoryServiceName();
}
