/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.publish;

import jp.ossc.nimbus.core.ServiceBaseMBean;
import jp.ossc.nimbus.core.ServiceName;

/**
 * {@link RequestConnectionFactoryService}MBeanC^tF[X<p>
 * 
 * @author M.Takata
 * @see RequestConnectionFactoryService
 */
public interface RequestConnectionFactoryServiceMBean extends ServiceBaseMBean{
    
    /**
     * vbZ[WyщbZ[W̑MɎgp{@link ServerConnectionFactory}T[rX̃T[rXݒ肷B<p>
     *
     * @param name ServerConnectionFactoryT[rX̃T[rX
     */
    public void setServerConnectionFactoryServiceName(ServiceName name);
    
    /**
     * vbZ[WyщbZ[W̑MɎgp{@link ServerConnectionFactory}T[rX̃T[rX擾B<p>
     *
     * @return ServerConnectionFactoryT[rX̃T[rX
     */
    public ServiceName getServerConnectionFactoryServiceName();
    
    /**
     * vbZ[WyщbZ[W̎MɎgp{@link MessageReceiver}T[rX̃T[rXݒ肷B<p>
     *
     * @param name MessageReceiverT[rX̃T[rX
     */
    public void setMessageReceiverServiceName(ServiceName name);
    
    /**
     * vbZ[WyщbZ[W̎MɎgp{@link MessageReceiver}T[rX̃T[rX擾B<p>
     *
     * @return MessageReceiverT[rX̃T[rX
     */
    public ServiceName getMessageReceiverServiceName();
    
    /**
     * bZ[W̑M񓯊ōsǂݒ肷B<p>
     * ftHǵAfalseœMB<br>
     *
     * @param isAsynch 񓯊Mꍇ́Atrue
     */
    public void setAsynchResponse(boolean isAsynch);
    
    /**
     * bZ[W̑M񓯊ōsǂ𔻒肷B<p>
     *
     * @return truȅꍇA񓯊M
     */
    public boolean isAsynchResponse();
    
    /**
     * bZ[W̑M̃gC񐔂ݒ肷B<p>
     * ftHǵA1B<br>
     *
     * @param count gC
     */
    public void setResponseRetryCount(int count);
    
    /**
     * bZ[W̑M̃gC񐔂擾B<p>
     *
     * @return gC
     */
    public int getResponseRetryCount();
    
    /**
     * bZ[W̑M̃gCԊu[ms]ݒ肷B<p>
     * ftHǵA50[ms]B<br>
     *
     * @param interval gCԊu[ms]
     */
    public void setResponseRetryInterval(long interval);
    
    /**
     * bZ[W̑M̃gCԊu[ms]擾B<p>
     *
     * @return gCԊu[ms]
     */
    public long getResponseRetryInterval();
}