/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.io.File;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.ArrayList;

/**
 * WzMX|XB<p>
 * 
 * @author M.Takata
 */
public class ConcentrateResponse implements Serializable{
    
    private static final long serialVersionUID = 7100038841123910324L;
    
    private String group;
    private Date date;
    private String key;
    private List<File> files;
    private List<Boolean> compressed;
    
    public ConcentrateResponse(){
    }
    
    public String getGroup(){
        return group;
    }
    
    public void setGroup(String group){
        this.group = group;
    }
    
    public Date getDate(){
        return date;
    }
    
    public void setDate(Date date){
        this.date = date;
    }
    
    public String getKey(){
        return key;
    }
    
    public void setKey(String key){
        this.key = key;
    }
    
    public File[] getFiles(){
        return files == null ? new File[0] : (File[])files.toArray(new File[files.size()]);
    }
    
    public boolean[] getFileCompressed(){
        if(compressed == null){
            return new boolean[0];
        }
        Boolean[] compressedFlags = compressed.toArray(new Boolean[compressed.size()]);
        boolean[] result = new boolean[compressedFlags.length];
        for(int i = 0; i < compressedFlags.length; i++){
            result[i] = compressedFlags[i].booleanValue();
        }
        return result;
    }
    
    public void addFile(File file){
        addFile(file, false);
    }
    
    public void addFiles(File[] files){
        for(int i = 0; i < files.length; i++){
            addFile(files[i]);
        }
    }
    
    public void addFile(File file, boolean isCompressed){
        if(files == null){
            files = new ArrayList<File>();
            compressed = new ArrayList<Boolean>();
        }
        files.add(file);
        compressed.add(isCompressed);
    }
    
    public void addFiles(File[] files, boolean[] isCompressed){
        for(int i = 0; i < files.length; i++){
            addFile(files[i], isCompressed[i]);
        }
    }
}