/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.scheduler;

import java.util.Date;
import java.text.SimpleDateFormat;
import java.sql.*;

import jp.ossc.nimbus.core.*;
import jp.ossc.nimbus.service.sql.*;


/**
 * f[^x[XXPW[쐬T[rXB<p>
 * XPW[̍쐬L̔SQLɈϏB<br>
 *
 * @author M.Takata
 */
public class DatabaseConditionScheduleMakerService
 extends DefaultScheduleMakerService
 implements DatabaseConditionScheduleMakerServiceMBean{
    
    private static final long serialVersionUID = -5158949647626532438L;
    protected ServiceName connectionFactoryServiceName;
    protected ConnectionFactory connectionFactory;
    
    protected String query;
    protected String dateFormat;
    
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public void setConnectionFactoryServiceName(ServiceName name){
        connectionFactoryServiceName = name;
    }
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public ServiceName getConnectionFactoryServiceName(){
        return connectionFactoryServiceName;
    }
    
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public void setQuery(String query){
        this.query = query;
    }
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public String getQuery(){
        return query;
    }
    
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public void setDateFormat(String format){
        dateFormat = format;
    }
    // DatabaseConditionScheduleMakerServiceMBeanJavaDoc
    public String getDateFormat(){
        return dateFormat;
    }
    
    /**
     * T[rX̊JnsB<p>
     *
     * @exception Exception T[rX̊JnɎsꍇ
     */
    public void startService() throws Exception{
        
        if(connectionFactoryServiceName != null){
            connectionFactory = (ConnectionFactory)ServiceManagerFactory
                .getServiceObject(connectionFactoryServiceName);
        }
        if(connectionFactory == null){
            throw new IllegalArgumentException("ConnectionFactory is null.");
        }
        if(query == null){
            throw new IllegalArgumentException("Query is null.");
        }
    }
    
    /**
     * {@link ConnectionFactory}ݒ肷B<p>
     *
     * @param factory ConnectionFactory
     */
    public void setConnectionFactory(ConnectionFactory factory){
        connectionFactory = factory;
    }
    
    /**
     * {@link ConnectionFactory}擾B<p>
     *
     * @return ConnectionFactory
     */
    public ConnectionFactory getConnectionFactory(){
        return connectionFactory;
    }
    
    /**
     * ̓tŁAXPW[쐬Kv邩ǂ𔻒肷B<p>
     * {@link #setQuery(String)}Ŏw肳ꂽSQL̖ߍ݃p[^ɁAŎw肳ꂽdateݒ肵ĎsB<br>
     * sʂ́ABoolean^Al^A^̂ꂩz肵ĂA<br>
     * Boolean^̏ꍇ́Â܂ܖ߂lƂB<br>
     * l^̏ꍇ́A0ȊO̒l̏ꍇA߂ltrueƂB<br>
     * ^̏ꍇ́A"0"ȊO̒l̏ꍇA߂ltrueƂB<br>
     *
     * @param date 쐬
     * @param master XPW[}X^
     * @return truȅꍇAKv
     * @exception ScheduleMakeException Ɏsꍇ
     */
    protected boolean isNecessaryMake(Date date, ScheduleMaster master)
     throws ScheduleMakeException{
        Connection con = null;
        try{
            con = connectionFactory.getConnection();
        }catch(ConnectionFactoryException e){
            throw new ScheduleMakeException(e);
        }
        
        boolean result = false;
        PreparedStatement st = null;
        ResultSet rs = null;
        try{
            st = con.prepareStatement(query);
            ParameterMetaData paramData = st.getParameterMetaData();
            if(paramData == null){
                if(dateFormat == null){
                    st.setDate(1, new java.sql.Date(date.getTime()));
                }else{
                    st.setString(1, new SimpleDateFormat(dateFormat).format(date));
                }
            }else{
                for(int i = 0; i < paramData.getParameterCount(); i++){
                    if(dateFormat == null){
                        st.setDate(i + 1, new java.sql.Date(date.getTime()));
                    }else{
                        st.setString(i + 1, new SimpleDateFormat(dateFormat).format(date));
                    }
                }
            }
            rs = st.executeQuery();
            if(!rs.next()){
                throw new ScheduleMakeException("Size of ResultSet is 0.");
            }
            Object ret = rs.getObject(1);
            if(rs.wasNull()){
                throw new ScheduleMakeException("Result value is null.");
            }
            if(ret instanceof Boolean){
                result = ((Boolean)ret).booleanValue();
            }else if(ret instanceof Number){
                result = ((Number)ret).intValue() != 0;
            }else{
                result = !"0".equals(ret.toString());
            }
        }catch(SQLException e){
            throw new ScheduleMakeException(e);
        }finally{
            if(st != null){
                try{
                    st.close();
                }catch(SQLException e){
                }
            }
            if(rs != null){
                try{
                    rs.close();
                }catch(SQLException e){
                }
            }
            if(con != null){
                try{
                    con.close();
                }catch(SQLException e){
                }
            }
        }
        return result;
    }
}