/*
 * This software is distributed under following license based on modified BSD
 * style license.
 * ----------------------------------------------------------------------
 * 
 * Copyright 2009 The Nimbus2 Project. All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 * 
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer. 
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE NIMBUS PROJECT ``AS IS'' AND ANY EXPRESS
 * OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN
 * NO EVENT SHALL THE NIMBUS PROJECT OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of the Nimbus2 Project.
 */
package jp.ossc.nimbus.service.semaphore;

/**
 * Z}tHC^[tFCXB<p>
 * 
 * @author H.Nakano
 */
public interface Semaphore{
    
    /**
     * Z}tH̃\[Xl҂B<p>
     * 
     * @param timeOutMiliSecond ő҂[ms]
     * @param maxWaitCount ő哯l҂
     * @param forceFreeMiliSecond J[ms]
     * @return l̏ꍇAtrue
     */
    public boolean getResource(
        long timeOutMiliSecond,
        int maxWaitCount,
        long forceFreeMiliSecond
    );
    
    /**
     * Z}tH̃\[Xl҂B<p>
     * 
     * @param timeOutMiliSecond ő҂[ms]
     * @param maxWaitCount ő哯l҂
     * @return l̏ꍇAtrue
     */
    public boolean getResource(long timeOutMiliSecond, int maxWaitCount);
    
    /**
     * Z}tH̃\[Xl҂B<p>
     * 
     * @param timeOutMiliSecond ő҂[ms]
     * @return l̏ꍇAtrue
     */
    public boolean getResource(long timeOutMiliSecond);
    
    /**
     * Z}tH̃\[Xl҂B<p>
     * 
     * @param maxWaitCount ő哯l҂
     * @return l̏ꍇAtrue
     */
    public boolean getResource(int maxWaitCount);
    
    /**
     * Z}tH̃\[Xl҂B<p>
     * 
     * @return l̏ꍇAtrue
     */
    public boolean getResource();
    
    /**
     * lZ}tH̃\[XJB<p>
     */
    public void freeResource();
    
    /**
     * Z}tH̃\[X擾B<p>
     *
     * @return Z}tH̃\[X
     */
    public int getResourceCapacity();
    
    /**
     * Z}tH̃\[Xݒ肷B<p>
     *
     * @param capa Z}tH̃\[X
     */
    public void setResourceCapacity(int capa);
    
    /**
     * Z}tHɑ΂Ėl҂Xbhsleep鎞Ԃݒ肷B<p>
     * Z}tH҂̐擪łȂꍇ́AĂsleepB<br>
     *
     * @param millis Z}tHɑ΂Ėl҂Xbhsleep鎞[ms]
     */
    public void setSleepTime(long millis);
    
    /**
     * Z}tHɑ΂Ėl҂Xbhsleep鎞Ԃ擾B<p>
     *
     * @return Z}tHɑ΂Ėl҂Xbhsleep鎞[ms]
     */
    public long getSleepTime();
    
    /**
     * \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]ݒ肷B<p>
     * \[X󂢂Ăđ҂ĂXbhꍇ́ÃXbhNB<br>
     * ftHǵA`FbNȂB
     *
     * @param millis \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]
     */
    public void setCheckInterval(long millis);
    
    /**
     * \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]擾B<p>
     *
     * @return \[X󂢂Ă邩IɃ`FbN鎞ԊԊu[ms]
     */
    public long getCheckInterval();
    
    /**
     * [\[X̎擾Ɖ̃Xbh֘At邩ǂݒ肷B<p>
     * ftHgtrueŁA\[X擾Xbh̉󂯕tȂB<br>
     * ܂Afalseɂꍇ́A^CAEg͖ƂȂB<br>
     *
     * @param isBinding \[X擾Xbh̉󂯕tȂ悤ɂꍇ́Atrue
     */
    public void setThreadBinding(boolean isBinding);
    
    /**
     * [\[X̎擾Ɖ̃Xbh֘At邩ǂ𔻒肷B<p>
     *
     * @return truȅꍇ́A\[X擾Xbh̉󂯕tȂ
     */
    public boolean isThreadBinding();
    
    /**
     * Z}tH̎c胊\[X擾B<p>
     * 
     * @return Z}tH̎c胊\[X
     */
    public int getResourceRemain();
    
    /**
     * Z}tHl҂XbhJAZ}tHl҂󂯕tȂ悤ɂB<p>
     */
    public void release();
    
    /**
     * Z}tHl҂̎tJnB<p>
     * {@link #release()}ďoɁAZ}tHl҂󂯕t悤ɂB
     */
    public void accept();
    
    /**
     * Z}tHl҂ĂXbh擾B<p>
     * 
     * @return Z}tHl҂ĂXbh
     */
    public int getWaitingCount();
    
    /**
     * Z}tH̍őgpт擾B<p>
     *
     * @return őgp
     */
    public int getMaxUsedResource();
    
    /**
     * Z}tH̍ő҂т擾B<p>
     *
     * @return ő҂
     */
    public int getMaxWaitedCount();
}
